// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnTlvPartnerStateVer15 implements OFBsnTlvPartnerState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerStateVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 5;

        private final static Set<OFBsnLacpState> DEFAULT_VALUE = ImmutableSet.<OFBsnLacpState>of();

    // OF message fields
    private final Set<OFBsnLacpState> value;
//
    // Immutable default instance
    final static OFBsnTlvPartnerStateVer15 DEFAULT = new OFBsnTlvPartnerStateVer15(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFBsnTlvPartnerStateVer15(Set<OFBsnLacpState> value) {
        if(value == null) {
            throw new NullPointerException("OFBsnTlvPartnerStateVer15: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x36;
    }

    @Override
    public Set<OFBsnLacpState> getValue() {
        return value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFBsnTlvPartnerState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnTlvPartnerState.Builder {
        final OFBsnTlvPartnerStateVer15 parentMessage;

        // OF message fields
        private boolean valueSet;
        private Set<OFBsnLacpState> value;

        BuilderWithParent(OFBsnTlvPartnerStateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x36;
    }

    @Override
    public Set<OFBsnLacpState> getValue() {
        return value;
    }

    @Override
    public OFBsnTlvPartnerState.Builder setValue(Set<OFBsnLacpState> value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFBsnTlvPartnerState build() {
                Set<OFBsnLacpState> value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFBsnTlvPartnerStateVer15(
                    value
                );
        }

    }

    static class Builder implements OFBsnTlvPartnerState.Builder {
        // OF message fields
        private boolean valueSet;
        private Set<OFBsnLacpState> value;

    @Override
    public int getType() {
        return 0x36;
    }

    @Override
    public Set<OFBsnLacpState> getValue() {
        return value;
    }

    @Override
    public OFBsnTlvPartnerState.Builder setValue(Set<OFBsnLacpState> value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFBsnTlvPartnerState build() {
            Set<OFBsnLacpState> value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFBsnTlvPartnerStateVer15(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnTlvPartnerState> {
        @Override
        public OFBsnTlvPartnerState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x36
            short type = bb.readShort();
            if(type != (short) 0x36)
                throw new OFParseError("Wrong type: Expected=0x36(0x36), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 5)
                throw new OFParseError("Wrong length: Expected=5(5), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            Set<OFBsnLacpState> value = OFBsnLacpStateSerializerVer15.readFrom(bb);

            OFBsnTlvPartnerStateVer15 bsnTlvPartnerStateVer15 = new OFBsnTlvPartnerStateVer15(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnTlvPartnerStateVer15);
            return bsnTlvPartnerStateVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnTlvPartnerStateVer15Funnel FUNNEL = new OFBsnTlvPartnerStateVer15Funnel();
    static class OFBsnTlvPartnerStateVer15Funnel implements Funnel<OFBsnTlvPartnerStateVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnTlvPartnerStateVer15 message, PrimitiveSink sink) {
            // fixed value property type = 0x36
            sink.putShort((short) 0x36);
            // fixed value property length = 5
            sink.putShort((short) 0x5);
            OFBsnLacpStateSerializerVer15.putTo(message.value, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnTlvPartnerStateVer15> {
        @Override
        public void write(ByteBuf bb, OFBsnTlvPartnerStateVer15 message) {
            // fixed value property type = 0x36
            bb.writeShort((short) 0x36);
            // fixed value property length = 5
            bb.writeShort((short) 0x5);
            OFBsnLacpStateSerializerVer15.writeTo(bb, message.value);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerStateVer15(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnTlvPartnerStateVer15 other = (OFBsnTlvPartnerStateVer15) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
