/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;

public class PrimitiveSinkUtils {
    private PrimitiveSinkUtils() {
    }

    public static void putNullableStringTo(PrimitiveSink sink, @Nullable CharSequence nullableChars) {
        sink.putBoolean(nullableChars != null);
        if (nullableChars != null) {
            sink.putInt(nullableChars.length());
            sink.putUnencodedChars(nullableChars);
        }
    }

    public static void putNullableTo(PrimitiveSink sink, @Nullable PrimitiveSinkable nullableObj) {
        sink.putBoolean(nullableObj != null);
        if (nullableObj != null) {
            nullableObj.putTo(sink);
        }
    }

    public static void putSortedSetTo(PrimitiveSink sink, SortedSet<? extends PrimitiveSinkable> set) {
        sink.putInt(set.size());
        for (PrimitiveSinkable primitiveSinkable : set) {
            primitiveSinkable.putTo(sink);
        }
    }

    public static void putListTo(PrimitiveSink sink, List<? extends PrimitiveSinkable> list) {
        sink.putInt(list.size());
        for (PrimitiveSinkable primitiveSinkable : list) {
            primitiveSinkable.putTo(sink);
        }
    }
}

