/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.annotations.Immutable;
import org.projectfloodlight.openflow.types.OFValueType;

@Immutable
public class OFConnectionIndex
implements OFValueType<OFConnectionIndex> {
    static final int LENGTH = 4;
    private final int connectionIndex;

    private OFConnectionIndex(int connectionIndex) {
        this.connectionIndex = connectionIndex;
    }

    public static OFConnectionIndex of(int connectionIndex) {
        return new OFConnectionIndex(connectionIndex);
    }

    public void write4Bytes(ByteBuf c) {
        c.writeInt(this.connectionIndex);
    }

    public static OFConnectionIndex read4Bytes(ByteBuf c) {
        return OFConnectionIndex.of(c.readInt());
    }

    @Override
    public OFConnectionIndex applyMask(OFConnectionIndex mask) {
        return OFConnectionIndex.of(this.connectionIndex & mask.connectionIndex);
    }

    @Override
    public int compareTo(OFConnectionIndex o) {
        return UnsignedInts.compare((int)this.connectionIndex, (int)o.connectionIndex);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putInt(this.connectionIndex);
    }

    @Override
    public int getLength() {
        return 4;
    }

    public String toString() {
        return UnsignedInts.toString((int)this.connectionIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectionIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFConnectionIndex other = (OFConnectionIndex)obj;
        return this.connectionIndex == other.connectionIndex;
    }
}

