/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortMod;
import org.projectfloodlight.openflow.protocol.OFPortModProp;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFPortConfigSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortModPropVer15;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortModVer15
implements OFPortMod {
    private static final Logger logger = LoggerFactory.getLogger(OFPortModVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 32;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortConfig> DEFAULT_MASK = ImmutableSet.of();
    private static final List<OFPortModProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final Set<OFPortConfig> config;
    private final Set<OFPortConfig> mask;
    private final List<OFPortModProp> properties;
    static final OFPortModVer15 DEFAULT = new OFPortModVer15(0L, DEFAULT_PORT_NO, DEFAULT_HW_ADDR, DEFAULT_CONFIG, DEFAULT_MASK, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFPortModVer15Funnel FUNNEL = new OFPortModVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortModVer15(long xid, OFPort portNo, MacAddress hwAddr, Set<OFPortConfig> config, Set<OFPortConfig> mask, List<OFPortModProp> properties) {
        if (portNo == null) {
            throw new NullPointerException("OFPortModVer15: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFPortModVer15: property hwAddr cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFPortModVer15: property config cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFPortModVer15: property mask cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFPortModVer15: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.config = config;
        this.mask = mask;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.PORT_MOD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortConfig> getMask() {
        return this.mask;
    }

    @Override
    public long getAdvertise() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property advertise not supported in version 1.5");
    }

    @Override
    public List<OFPortModProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFPortMod.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortModVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModVer15 other = (OFPortModVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.mask == null ? other.mask != null : !this.mask.equals(other.mask)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModVer15 other = (OFPortModVer15)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.mask == null ? other.mask != null : !this.mask.equals(other.mask)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortModVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortModVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(16);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.portNo.write4Bytes(bb);
            bb.writeZero(4);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            OFPortConfigSerializerVer15.writeTo(bb, message.config);
            OFPortConfigSerializerVer15.writeTo(bb, message.mask);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFPortModVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortModVer15Funnel
    implements Funnel<OFPortModVer15> {
        private static final long serialVersionUID = 1L;

        OFPortModVer15Funnel() {
        }

        public void funnel(OFPortModVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)16);
            sink.putLong(message.xid);
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            OFPortConfigSerializerVer15.putTo(message.config, sink);
            OFPortConfigSerializerVer15.putTo(message.mask, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortMod> {
        Reader() {
        }

        @Override
        public OFPortMod readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFType.PORT_MOD(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 32) {
                throw new OFParseError("Wrong length: Expected to be >= 32, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            bb.skipBytes(4);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            Set<OFPortConfig> config = OFPortConfigSerializerVer15.readFrom(bb);
            Set<OFPortConfig> mask = OFPortConfigSerializerVer15.readFrom(bb);
            List<OFPortModProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortModPropVer15.READER);
            OFPortModVer15 portModVer15 = new OFPortModVer15(xid, portNo, hwAddr, config, mask, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portModVer15);
            }
            return portModVer15;
        }
    }

    static class Builder
    implements OFPortMod.Builder {
        private boolean xidSet;
        private long xid;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean maskSet;
        private Set<OFPortConfig> mask;
        private boolean propertiesSet;
        private List<OFPortModProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortMod.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortMod.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortMod.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getMask() {
            return this.mask;
        }

        @Override
        public OFPortMod.Builder setMask(Set<OFPortConfig> mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public long getAdvertise() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertise not supported in version 1.5");
        }

        @Override
        public OFPortMod.Builder setAdvertise(long advertise) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertise not supported in version 1.5");
        }

        @Override
        public List<OFPortModProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPortMod.Builder setProperties(List<OFPortModProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFPortMod build() {
            List<OFPortModProp> properties;
            Set<OFPortConfig> mask;
            Set<OFPortConfig> config;
            MacAddress hwAddr;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortConfig> set2 = mask = this.maskSet ? this.mask : DEFAULT_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            List<OFPortModProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPortModVer15(xid, portNo, hwAddr, config, mask, properties);
        }
    }

    static class BuilderWithParent
    implements OFPortMod.Builder {
        final OFPortModVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean maskSet;
        private Set<OFPortConfig> mask;
        private boolean propertiesSet;
        private List<OFPortModProp> properties;

        BuilderWithParent(OFPortModVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.PORT_MOD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortMod.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortMod.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortMod.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortMod.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getMask() {
            return this.mask;
        }

        @Override
        public OFPortMod.Builder setMask(Set<OFPortConfig> mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public long getAdvertise() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertise not supported in version 1.5");
        }

        @Override
        public OFPortMod.Builder setAdvertise(long advertise) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property advertise not supported in version 1.5");
        }

        @Override
        public List<OFPortModProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPortMod.Builder setProperties(List<OFPortModProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFPortMod build() {
            List properties;
            Set mask;
            Set config;
            MacAddress hwAddr;
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPortModVer15(xid, portNo, hwAddr, config, mask, properties);
        }
    }
}

