/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnSpeedCapabilities;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnSpeedCapabilitiesVer15
implements OFPortDescPropBsnSpeedCapabilities {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnSpeedCapabilitiesVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 36;
    private static final U64 DEFAULT_CURRENT = U64.ZERO;
    private static final U64 DEFAULT_AVAILABLE = U64.ZERO;
    private static final U64 DEFAULT_SUPPORTED = U64.ZERO;
    private final U64 current;
    private final U64 available;
    private final U64 supported;
    static final OFPortDescPropBsnSpeedCapabilitiesVer15 DEFAULT = new OFPortDescPropBsnSpeedCapabilitiesVer15(DEFAULT_CURRENT, DEFAULT_AVAILABLE, DEFAULT_SUPPORTED);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnSpeedCapabilitiesVer15Funnel FUNNEL = new OFPortDescPropBsnSpeedCapabilitiesVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnSpeedCapabilitiesVer15(U64 current, U64 available, U64 supported) {
        if (current == null) {
            throw new NullPointerException("OFPortDescPropBsnSpeedCapabilitiesVer15: property current cannot be null");
        }
        if (available == null) {
            throw new NullPointerException("OFPortDescPropBsnSpeedCapabilitiesVer15: property available cannot be null");
        }
        if (supported == null) {
            throw new NullPointerException("OFPortDescPropBsnSpeedCapabilitiesVer15: property supported cannot be null");
        }
        this.current = current;
        this.available = available;
        this.supported = supported;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 4L;
    }

    @Override
    public U64 getCurrent() {
        return this.current;
    }

    @Override
    public U64 getAvailable() {
        return this.available;
    }

    @Override
    public U64 getSupported() {
        return this.supported;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropBsnSpeedCapabilities.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnSpeedCapabilitiesVer15(");
        b.append("current=").append(this.current);
        b.append(", ");
        b.append("available=").append(this.available);
        b.append(", ");
        b.append("supported=").append(this.supported);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnSpeedCapabilitiesVer15 other = (OFPortDescPropBsnSpeedCapabilitiesVer15)obj;
        if (this.current == null ? other.current != null : !this.current.equals(other.current)) {
            return false;
        }
        if (this.available == null ? other.available != null : !this.available.equals(other.available)) {
            return false;
        }
        return !(this.supported == null ? other.supported != null : !this.supported.equals(other.supported));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.current == null ? 0 : this.current.hashCode());
        result = 31 * result + (this.available == null ? 0 : this.available.hashCode());
        result = 31 * result + (this.supported == null ? 0 : this.supported.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnSpeedCapabilitiesVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnSpeedCapabilitiesVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(36);
            bb.writeInt(6035143);
            bb.writeInt(4);
            bb.writeLong(message.current.getValue());
            bb.writeLong(message.available.getValue());
            bb.writeLong(message.supported.getValue());
        }
    }

    static class OFPortDescPropBsnSpeedCapabilitiesVer15Funnel
    implements Funnel<OFPortDescPropBsnSpeedCapabilitiesVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnSpeedCapabilitiesVer15Funnel() {
        }

        public void funnel(OFPortDescPropBsnSpeedCapabilitiesVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)36);
            sink.putInt(6035143);
            sink.putInt(4);
            message.current.putTo(sink);
            message.available.putTo(sink);
            message.supported.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnSpeedCapabilities> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 36) {
                throw new OFParseError("Wrong length: Expected=36(36), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 4) {
                throw new OFParseError("Wrong expType: Expected=0x4L(0x4L), got=" + expType);
            }
            U64 current = U64.ofRaw(bb.readLong());
            U64 available = U64.ofRaw(bb.readLong());
            U64 supported = U64.ofRaw(bb.readLong());
            OFPortDescPropBsnSpeedCapabilitiesVer15 portDescPropBsnSpeedCapabilitiesVer15 = new OFPortDescPropBsnSpeedCapabilitiesVer15(current, available, supported);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnSpeedCapabilitiesVer15);
            }
            return portDescPropBsnSpeedCapabilitiesVer15;
        }
    }

    static class Builder
    implements OFPortDescPropBsnSpeedCapabilities.Builder {
        private boolean currentSet;
        private U64 current;
        private boolean availableSet;
        private U64 available;
        private boolean supportedSet;
        private U64 supported;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 4L;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getCurrent() {
            return this.current;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setCurrent(U64 current) {
            this.current = current;
            this.currentSet = true;
            return this;
        }

        @Override
        public U64 getAvailable() {
            return this.available;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setAvailable(U64 available) {
            this.available = available;
            this.availableSet = true;
            return this;
        }

        @Override
        public U64 getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setSupported(U64 supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities build() {
            U64 supported;
            U64 available;
            U64 current;
            U64 u64 = current = this.currentSet ? this.current : DEFAULT_CURRENT;
            if (current == null) {
                throw new NullPointerException("Property current must not be null");
            }
            U64 u642 = available = this.availableSet ? this.available : DEFAULT_AVAILABLE;
            if (available == null) {
                throw new NullPointerException("Property available must not be null");
            }
            U64 u643 = supported = this.supportedSet ? this.supported : DEFAULT_SUPPORTED;
            if (supported == null) {
                throw new NullPointerException("Property supported must not be null");
            }
            return new OFPortDescPropBsnSpeedCapabilitiesVer15(current, available, supported);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnSpeedCapabilities.Builder {
        final OFPortDescPropBsnSpeedCapabilitiesVer15 parentMessage;
        private boolean currentSet;
        private U64 current;
        private boolean availableSet;
        private U64 available;
        private boolean supportedSet;
        private U64 supported;

        BuilderWithParent(OFPortDescPropBsnSpeedCapabilitiesVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 4L;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getCurrent() {
            return this.current;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setCurrent(U64 current) {
            this.current = current;
            this.currentSet = true;
            return this;
        }

        @Override
        public U64 getAvailable() {
            return this.available;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setAvailable(U64 available) {
            this.available = available;
            this.availableSet = true;
            return this;
        }

        @Override
        public U64 getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities.Builder setSupported(U64 supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnSpeedCapabilities build() {
            U64 supported;
            U64 available;
            U64 current;
            U64 u64 = current = this.currentSet ? this.current : this.parentMessage.current;
            if (current == null) {
                throw new NullPointerException("Property current must not be null");
            }
            U64 u642 = available = this.availableSet ? this.available : this.parentMessage.available;
            if (available == null) {
                throw new NullPointerException("Property available must not be null");
            }
            U64 u643 = supported = this.supportedSet ? this.supported : this.parentMessage.supported;
            if (supported == null) {
                throw new NullPointerException("Property supported must not be null");
            }
            return new OFPortDescPropBsnSpeedCapabilitiesVer15(current, available, supported);
        }
    }
}

