/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMplsTcMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmMplsTcVer15;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmMplsTcMaskedVer15
implements OFOxmMplsTcMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmMplsTcMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private static final U8 DEFAULT_VALUE_MASK = U8.ZERO;
    private final U8 value;
    private final U8 mask;
    static final OFOxmMplsTcMaskedVer15 DEFAULT = new OFOxmMplsTcMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmMplsTcMaskedVer15Funnel FUNNEL = new OFOxmMplsTcMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmMplsTcMaskedVer15(U8 value, U8 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmMplsTcMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmMplsTcMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147501826L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public U8 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.MPLS_TC;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        if (U8.NO_MASK.equals(this.mask)) {
            return new OFOxmMplsTcVer15(this.value);
        }
        if (U8.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmMplsTcMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmMplsTcMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmMplsTcMaskedVer15 other = (OFOxmMplsTcMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmMplsTcMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmMplsTcMaskedVer15 message) {
            bb.writeInt(-2147465470);
            bb.writeByte((int)message.value.getRaw());
            bb.writeByte((int)message.mask.getRaw());
        }
    }

    static class OFOxmMplsTcMaskedVer15Funnel
    implements Funnel<OFOxmMplsTcMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmMplsTcMaskedVer15Funnel() {
        }

        public void funnel(OFOxmMplsTcMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147465470);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmMplsTcMasked> {
        Reader() {
        }

        @Override
        public OFOxmMplsTcMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147465470) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004702L(0x80004702L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            U8 mask = U8.of(bb.readByte());
            OFOxmMplsTcMaskedVer15 oxmMplsTcMaskedVer15 = new OFOxmMplsTcMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmMplsTcMaskedVer15);
            }
            return oxmMplsTcMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmMplsTcMasked.Builder {
        private boolean valueSet;
        private U8 value;
        private boolean maskSet;
        private U8 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147501826L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmMplsTcMasked.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U8 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmMplsTcMasked.Builder setMask(U8 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.MPLS_TC;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmMplsTcMasked build() {
            U8 mask;
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U8 u82 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmMplsTcMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmMplsTcMasked.Builder {
        final OFOxmMplsTcMaskedVer15 parentMessage;
        private boolean valueSet;
        private U8 value;
        private boolean maskSet;
        private U8 mask;

        BuilderWithParent(OFOxmMplsTcMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147501826L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmMplsTcMasked.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U8 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmMplsTcMasked.Builder setMask(U8 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.MPLS_TC;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmMplsTcMasked build() {
            U8 mask;
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U8 u82 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmMplsTcMaskedVer15(value, mask);
        }
    }
}

