/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnLagId;
import org.projectfloodlight.openflow.types.LagId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnLagIdVer15
implements OFOxmBsnLagId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnLagIdVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final LagId DEFAULT_VALUE = LagId.NONE;
    private final LagId value;
    static final OFOxmBsnLagIdVer15 DEFAULT = new OFOxmBsnLagIdVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnLagIdVer15Funnel FUNNEL = new OFOxmBsnLagIdVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnLagIdVer15(LagId value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnLagIdVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 197124L;
    }

    @Override
    public LagId getValue() {
        return this.value;
    }

    @Override
    public MatchField<LagId> getMatchField() {
        return MatchField.BSN_LAG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<LagId> getCanonical() {
        return this;
    }

    @Override
    public LagId getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnLagId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnLagIdVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnLagIdVer15 other = (OFOxmBsnLagIdVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnLagIdVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnLagIdVer15 message) {
            bb.writeInt(197124);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnLagIdVer15Funnel
    implements Funnel<OFOxmBsnLagIdVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnLagIdVer15Funnel() {
        }

        public void funnel(OFOxmBsnLagIdVer15 message, PrimitiveSink sink) {
            sink.putInt(197124);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnLagId> {
        Reader() {
        }

        @Override
        public OFOxmBsnLagId readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197124) {
                throw new OFParseError("Wrong typeLen: Expected=0x30204L(0x30204L), got=" + typeLen);
            }
            LagId value = LagId.read4Bytes(bb);
            OFOxmBsnLagIdVer15 oxmBsnLagIdVer15 = new OFOxmBsnLagIdVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnLagIdVer15);
            }
            return oxmBsnLagIdVer15;
        }
    }

    static class Builder
    implements OFOxmBsnLagId.Builder {
        private boolean valueSet;
        private LagId value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197124L;
        }

        @Override
        public LagId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnLagId.Builder setValue(LagId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<LagId> getMatchField() {
            return MatchField.BSN_LAG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<LagId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public LagId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnLagId build() {
            LagId value;
            LagId lagId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnLagIdVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnLagId.Builder {
        final OFOxmBsnLagIdVer15 parentMessage;
        private boolean valueSet;
        private LagId value;

        BuilderWithParent(OFOxmBsnLagIdVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197124L;
        }

        @Override
        public LagId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnLagId.Builder setValue(LagId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<LagId> getMatchField() {
            return MatchField.BSN_LAG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<LagId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public LagId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnLagId build() {
            LagId value;
            LagId lagId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnLagIdVer15(value);
        }
    }
}

