/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowLightweightStatsEntry;
import org.projectfloodlight.openflow.protocol.OFFlowStatsReason;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.stat.Stat;
import org.projectfloodlight.openflow.protocol.ver15.ChannelUtilsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowStatsReasonSerializerVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowLightweightStatsEntryVer15
implements OFFlowLightweightStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowLightweightStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    static final int MAXIMUM_LENGTH = 65535;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final int DEFAULT_PRIORITY = 0;
    private static final Match DEFAULT_MATCH = OFFactoryVer15.MATCH_WILDCARD_ALL;
    private final TableId tableId;
    private final OFFlowStatsReason reason;
    private final int priority;
    private final Match match;
    private final Stat stats;
    static final Reader READER = new Reader();
    static final OFFlowLightweightStatsEntryVer15Funnel FUNNEL = new OFFlowLightweightStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFFlowLightweightStatsEntryVer15(TableId tableId, OFFlowStatsReason reason, int priority, Match match, Stat stats) {
        if (tableId == null) {
            throw new NullPointerException("OFFlowLightweightStatsEntryVer15: property tableId cannot be null");
        }
        if (reason == null) {
            throw new NullPointerException("OFFlowLightweightStatsEntryVer15: property reason cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFFlowLightweightStatsEntryVer15: property match cannot be null");
        }
        if (stats == null) {
            throw new NullPointerException("OFFlowLightweightStatsEntryVer15: property stats cannot be null");
        }
        this.tableId = tableId;
        this.reason = reason;
        this.priority = U16.normalize(priority);
        this.match = match;
        this.stats = stats;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFFlowStatsReason getReason() {
        return this.reason;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public Stat getStats() {
        return this.stats;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFFlowLightweightStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowLightweightStatsEntryVer15(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("reason=").append((Object)this.reason);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("stats=").append(this.stats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowLightweightStatsEntryVer15 other = (OFFlowLightweightStatsEntryVer15)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals((Object)other.reason)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return !(this.stats == null ? other.stats != null : !this.stats.equals(other.stats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.stats == null ? 0 : this.stats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowLightweightStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFlowLightweightStatsEntryVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.tableId.writeByte(bb);
            OFFlowStatsReasonSerializerVer15.writeTo(bb, message.reason);
            bb.writeShort((int)U16.t(message.priority));
            message.match.writeTo(bb);
            message.stats.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFFlowLightweightStatsEntryVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFFlowLightweightStatsEntryVer15Funnel
    implements Funnel<OFFlowLightweightStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFFlowLightweightStatsEntryVer15Funnel() {
        }

        public void funnel(OFFlowLightweightStatsEntryVer15 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            OFFlowStatsReasonSerializerVer15.putTo(message.reason, sink);
            sink.putInt(message.priority);
            message.match.putTo(sink);
            message.stats.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowLightweightStatsEntry> {
        Reader() {
        }

        @Override
        public OFFlowLightweightStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            TableId tableId = TableId.readByte(bb);
            OFFlowStatsReason reason = OFFlowStatsReasonSerializerVer15.readFrom(bb);
            int priority = U16.f(bb.readShort());
            Match match = ChannelUtilsVer15.readOFMatch(bb);
            Stat stats = ChannelUtilsVer15.readOFStat(bb);
            OFFlowLightweightStatsEntryVer15 flowLightweightStatsEntryVer15 = new OFFlowLightweightStatsEntryVer15(tableId, reason, priority, match, stats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowLightweightStatsEntryVer15);
            }
            return flowLightweightStatsEntryVer15;
        }
    }

    static class Builder
    implements OFFlowLightweightStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean reasonSet;
        private OFFlowStatsReason reason;
        private boolean prioritySet;
        private int priority;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFFlowStatsReason getReason() {
            return this.reason;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setReason(OFFlowStatsReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowLightweightStatsEntry build() {
            Match match;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            if (!this.reasonSet) {
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            }
            if (this.reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            int priority = this.prioritySet ? this.priority : 0;
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            if (!this.statsSet) {
                throw new IllegalStateException("Property stats doesn't have default value -- must be set");
            }
            if (this.stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFFlowLightweightStatsEntryVer15(tableId, this.reason, priority, match, this.stats);
        }
    }

    static class BuilderWithParent
    implements OFFlowLightweightStatsEntry.Builder {
        final OFFlowLightweightStatsEntryVer15 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean reasonSet;
        private OFFlowStatsReason reason;
        private boolean prioritySet;
        private int priority;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;

        BuilderWithParent(OFFlowLightweightStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFFlowStatsReason getReason() {
            return this.reason;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setReason(OFFlowStatsReason reason) {
            this.reason = reason;
            this.reasonSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public Stat getStats() {
            return this.stats;
        }

        @Override
        public OFFlowLightweightStatsEntry.Builder setStats(Stat stats) {
            this.stats = stats;
            this.statsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowLightweightStatsEntry build() {
            Stat stats;
            Match match;
            OFFlowStatsReason reason;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            OFFlowStatsReason oFFlowStatsReason = reason = this.reasonSet ? this.reason : this.parentMessage.reason;
            if (reason == null) {
                throw new NullPointerException("Property reason must not be null");
            }
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            Stat stat = stats = this.statsSet ? this.stats : this.parentMessage.stats;
            if (stats == null) {
                throw new NullPointerException("Property stats must not be null");
            }
            return new OFFlowLightweightStatsEntryVer15(tableId, reason, priority, match, stats);
        }
    }
}

