/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUdpSrc;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUdpSrcVer15
implements OFBsnTlvUdpSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUdpSrcVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvUdpSrcVer15 DEFAULT = new OFBsnTlvUdpSrcVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUdpSrcVer15Funnel FUNNEL = new OFBsnTlvUdpSrcVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUdpSrcVer15(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 36;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvUdpSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUdpSrcVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUdpSrcVer15 other = (OFBsnTlvUdpSrcVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUdpSrcVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUdpSrcVer15 message) {
            bb.writeShort(36);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvUdpSrcVer15Funnel
    implements Funnel<OFBsnTlvUdpSrcVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUdpSrcVer15Funnel() {
        }

        public void funnel(OFBsnTlvUdpSrcVer15 message, PrimitiveSink sink) {
            sink.putShort((short)36);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUdpSrc> {
        Reader() {
        }

        @Override
        public OFBsnTlvUdpSrc readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 36) {
                throw new OFParseError("Wrong type: Expected=0x24(0x24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvUdpSrcVer15 bsnTlvUdpSrcVer15 = new OFBsnTlvUdpSrcVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUdpSrcVer15);
            }
            return bsnTlvUdpSrcVer15;
        }
    }

    static class Builder
    implements OFBsnTlvUdpSrc.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 36;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpSrc.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvUdpSrc build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvUdpSrcVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUdpSrc.Builder {
        final OFBsnTlvUdpSrcVer15 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvUdpSrcVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 36;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpSrc.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvUdpSrc build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUdpSrcVer15(value);
        }
    }
}

