/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPacketField;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPacketField;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPacketFieldSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPacketFieldVer15
implements OFBsnTlvPacketField {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPacketFieldVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnPacketField value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPacketFieldVer15Funnel FUNNEL = new OFBsnTlvPacketFieldVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPacketFieldVer15(OFBsnPacketField value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPacketFieldVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 222;
    }

    @Override
    public OFBsnPacketField getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPacketField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPacketFieldVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPacketFieldVer15 other = (OFBsnTlvPacketFieldVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPacketFieldVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPacketFieldVer15 message) {
            bb.writeShort(222);
            bb.writeShort(6);
            OFBsnPacketFieldSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPacketFieldVer15Funnel
    implements Funnel<OFBsnTlvPacketFieldVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPacketFieldVer15Funnel() {
        }

        public void funnel(OFBsnTlvPacketFieldVer15 message, PrimitiveSink sink) {
            sink.putShort((short)222);
            sink.putShort((short)6);
            OFBsnPacketFieldSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPacketField> {
        Reader() {
        }

        @Override
        public OFBsnTlvPacketField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 222) {
                throw new OFParseError("Wrong type: Expected=0xde(0xde), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPacketField value = OFBsnPacketFieldSerializerVer15.readFrom(bb);
            OFBsnTlvPacketFieldVer15 bsnTlvPacketFieldVer15 = new OFBsnTlvPacketFieldVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPacketFieldVer15);
            }
            return bsnTlvPacketFieldVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPacketField.Builder {
        private boolean valueSet;
        private OFBsnPacketField value;

        Builder() {
        }

        @Override
        public int getType() {
            return 222;
        }

        @Override
        public OFBsnPacketField getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPacketField.Builder setValue(OFBsnPacketField value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPacketField build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPacketFieldVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPacketField.Builder {
        final OFBsnTlvPacketFieldVer15 parentMessage;
        private boolean valueSet;
        private OFBsnPacketField value;

        BuilderWithParent(OFBsnTlvPacketFieldVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 222;
        }

        @Override
        public OFBsnPacketField getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPacketField.Builder setValue(OFBsnPacketField value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPacketField build() {
            OFBsnPacketField value;
            OFBsnPacketField oFBsnPacketField = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPacketFieldVer15(value);
        }
    }
}

