/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnMetadata;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMetadata;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnMetadataSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMetadataVer15
implements OFBsnTlvMetadata {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMetadataVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnMetadata value;
    static final Reader READER = new Reader();
    static final OFBsnTlvMetadataVer15Funnel FUNNEL = new OFBsnTlvMetadataVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMetadataVer15(OFBsnMetadata value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvMetadataVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 221;
    }

    @Override
    public OFBsnMetadata getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvMetadata.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMetadataVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMetadataVer15 other = (OFBsnTlvMetadataVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMetadataVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMetadataVer15 message) {
            bb.writeShort(221);
            bb.writeShort(6);
            OFBsnMetadataSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvMetadataVer15Funnel
    implements Funnel<OFBsnTlvMetadataVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMetadataVer15Funnel() {
        }

        public void funnel(OFBsnTlvMetadataVer15 message, PrimitiveSink sink) {
            sink.putShort((short)221);
            sink.putShort((short)6);
            OFBsnMetadataSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMetadata> {
        Reader() {
        }

        @Override
        public OFBsnTlvMetadata readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 221) {
                throw new OFParseError("Wrong type: Expected=0xdd(0xdd), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnMetadata value = OFBsnMetadataSerializerVer15.readFrom(bb);
            OFBsnTlvMetadataVer15 bsnTlvMetadataVer15 = new OFBsnTlvMetadataVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMetadataVer15);
            }
            return bsnTlvMetadataVer15;
        }
    }

    static class Builder
    implements OFBsnTlvMetadata.Builder {
        private boolean valueSet;
        private OFBsnMetadata value;

        Builder() {
        }

        @Override
        public int getType() {
            return 221;
        }

        @Override
        public OFBsnMetadata getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMetadata.Builder setValue(OFBsnMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvMetadata build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMetadataVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMetadata.Builder {
        final OFBsnTlvMetadataVer15 parentMessage;
        private boolean valueSet;
        private OFBsnMetadata value;

        BuilderWithParent(OFBsnTlvMetadataVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 221;
        }

        @Override
        public OFBsnMetadata getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMetadata.Builder setValue(OFBsnMetadata value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvMetadata build() {
            OFBsnMetadata value;
            OFBsnMetadata oFBsnMetadata = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvMetadataVer15(value);
        }
    }
}

