/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBfdEndpoint;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBfdEndpoint;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBfdEndpointSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBfdEndpointVer15
implements OFBsnTlvBfdEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBfdEndpointVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final OFBsnBfdEndpoint value;
    static final Reader READER = new Reader();
    static final OFBsnTlvBfdEndpointVer15Funnel FUNNEL = new OFBsnTlvBfdEndpointVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBfdEndpointVer15(OFBsnBfdEndpoint value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBfdEndpointVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 176;
    }

    @Override
    public OFBsnBfdEndpoint getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvBfdEndpoint.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBfdEndpointVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBfdEndpointVer15 other = (OFBsnTlvBfdEndpointVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBfdEndpointVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBfdEndpointVer15 message) {
            bb.writeShort(176);
            bb.writeShort(5);
            OFBsnBfdEndpointSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvBfdEndpointVer15Funnel
    implements Funnel<OFBsnTlvBfdEndpointVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBfdEndpointVer15Funnel() {
        }

        public void funnel(OFBsnTlvBfdEndpointVer15 message, PrimitiveSink sink) {
            sink.putShort((short)176);
            sink.putShort((short)5);
            OFBsnBfdEndpointSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBfdEndpoint> {
        Reader() {
        }

        @Override
        public OFBsnTlvBfdEndpoint readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 176) {
                throw new OFParseError("Wrong type: Expected=0xb0(0xb0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnBfdEndpoint value = OFBsnBfdEndpointSerializerVer15.readFrom(bb);
            OFBsnTlvBfdEndpointVer15 bsnTlvBfdEndpointVer15 = new OFBsnTlvBfdEndpointVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBfdEndpointVer15);
            }
            return bsnTlvBfdEndpointVer15;
        }
    }

    static class Builder
    implements OFBsnTlvBfdEndpoint.Builder {
        private boolean valueSet;
        private OFBsnBfdEndpoint value;

        Builder() {
        }

        @Override
        public int getType() {
            return 176;
        }

        @Override
        public OFBsnBfdEndpoint getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdEndpoint.Builder setValue(OFBsnBfdEndpoint value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBfdEndpoint build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdEndpointVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBfdEndpoint.Builder {
        final OFBsnTlvBfdEndpointVer15 parentMessage;
        private boolean valueSet;
        private OFBsnBfdEndpoint value;

        BuilderWithParent(OFBsnTlvBfdEndpointVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 176;
        }

        @Override
        public OFBsnBfdEndpoint getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdEndpoint.Builder setValue(OFBsnBfdEndpoint value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBfdEndpoint build() {
            OFBsnBfdEndpoint value;
            OFBsnBfdEndpoint oFBsnBfdEndpoint = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdEndpointVer15(value);
        }
    }
}

