/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetMirroringRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetMirroringRequestVer15
implements OFBsnGetMirroringRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetMirroringRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_REPORT_MIRROR_PORTS = 0;
    private final long xid;
    private final short reportMirrorPorts;
    static final OFBsnGetMirroringRequestVer15 DEFAULT = new OFBsnGetMirroringRequestVer15(0L, 0);
    static final Reader READER = new Reader();
    static final OFBsnGetMirroringRequestVer15Funnel FUNNEL = new OFBsnGetMirroringRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetMirroringRequestVer15(long xid, short reportMirrorPorts) {
        this.xid = U32.normalize(xid);
        this.reportMirrorPorts = U8.normalize(reportMirrorPorts);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 4L;
    }

    @Override
    public short getReportMirrorPorts() {
        return this.reportMirrorPorts;
    }

    @Override
    public OFBsnGetMirroringRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetMirroringRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("reportMirrorPorts=").append(this.reportMirrorPorts);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetMirroringRequestVer15 other = (OFBsnGetMirroringRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.reportMirrorPorts == other.reportMirrorPorts;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetMirroringRequestVer15 other = (OFBsnGetMirroringRequestVer15)obj;
        return this.reportMirrorPorts == other.reportMirrorPorts;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.reportMirrorPorts;
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.reportMirrorPorts;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetMirroringRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGetMirroringRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(4);
            bb.writeByte((int)U8.t(message.reportMirrorPorts));
            bb.writeZero(3);
        }
    }

    static class OFBsnGetMirroringRequestVer15Funnel
    implements Funnel<OFBsnGetMirroringRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnGetMirroringRequestVer15Funnel() {
        }

        public void funnel(OFBsnGetMirroringRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(4);
            sink.putShort(message.reportMirrorPorts);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetMirroringRequest> {
        Reader() {
        }

        @Override
        public OFBsnGetMirroringRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 4) {
                throw new OFParseError("Wrong subtype: Expected=0x4L(0x4L), got=" + subtype);
            }
            short reportMirrorPorts = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFBsnGetMirroringRequestVer15 bsnGetMirroringRequestVer15 = new OFBsnGetMirroringRequestVer15(xid, reportMirrorPorts);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetMirroringRequestVer15);
            }
            return bsnGetMirroringRequestVer15;
        }
    }

    static class Builder
    implements OFBsnGetMirroringRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean reportMirrorPortsSet;
        private short reportMirrorPorts;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetMirroringRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 4L;
        }

        @Override
        public short getReportMirrorPorts() {
            return this.reportMirrorPorts;
        }

        @Override
        public OFBsnGetMirroringRequest.Builder setReportMirrorPorts(short reportMirrorPorts) {
            this.reportMirrorPorts = reportMirrorPorts;
            this.reportMirrorPortsSet = true;
            return this;
        }

        @Override
        public OFBsnGetMirroringRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            short reportMirrorPorts = this.reportMirrorPortsSet ? this.reportMirrorPorts : (short)0;
            return new OFBsnGetMirroringRequestVer15(xid, reportMirrorPorts);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetMirroringRequest.Builder {
        final OFBsnGetMirroringRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean reportMirrorPortsSet;
        private short reportMirrorPorts;

        BuilderWithParent(OFBsnGetMirroringRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetMirroringRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 4L;
        }

        @Override
        public short getReportMirrorPorts() {
            return this.reportMirrorPorts;
        }

        @Override
        public OFBsnGetMirroringRequest.Builder setReportMirrorPorts(short reportMirrorPorts) {
            this.reportMirrorPorts = reportMirrorPorts;
            this.reportMirrorPortsSet = true;
            return this;
        }

        @Override
        public OFBsnGetMirroringRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short reportMirrorPorts = this.reportMirrorPortsSet ? this.reportMirrorPorts : this.parentMessage.reportMirrorPorts;
            return new OFBsnGetMirroringRequestVer15(xid, reportMirrorPorts);
        }
    }
}

