/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdPopPbb;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdPopPbbVer15
implements OFActionIdPopPbb {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdPopPbbVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFActionIdPopPbbVer15 DEFAULT = new OFActionIdPopPbbVer15();
    static final OFActionIdPopPbbVer15 INSTANCE = new OFActionIdPopPbbVer15();
    static final Reader READER = new Reader();
    static final OFActionIdPopPbbVer15Funnel FUNNEL = new OFActionIdPopPbbVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdPopPbbVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.POP_PBB;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionIdPopPbb.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdPopPbbVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdPopPbbVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdPopPbbVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdPopPbbVer15 message) {
            bb.writeShort(27);
            bb.writeShort(4);
        }
    }

    static class OFActionIdPopPbbVer15Funnel
    implements Funnel<OFActionIdPopPbbVer15> {
        private static final long serialVersionUID = 1L;

        OFActionIdPopPbbVer15Funnel() {
        }

        public void funnel(OFActionIdPopPbbVer15 message, PrimitiveSink sink) {
            sink.putShort((short)27);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdPopPbb> {
        Reader() {
        }

        @Override
        public OFActionIdPopPbb readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 27) {
                throw new OFParseError("Wrong type: Expected=OFActionType.POP_PBB(27), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

