/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueDescPropMinRate;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueDescPropMinRateVer14
implements OFQueueDescPropMinRate {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueDescPropMinRateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final int DEFAULT_RATE = 0;
    private final int rate;
    static final OFQueueDescPropMinRateVer14 DEFAULT = new OFQueueDescPropMinRateVer14(0);
    static final Reader READER = new Reader();
    static final OFQueueDescPropMinRateVer14Funnel FUNNEL = new OFQueueDescPropMinRateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFQueueDescPropMinRateVer14(int rate) {
        this.rate = U16.normalize(rate);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFQueueDescPropMinRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueDescPropMinRateVer14(");
        b.append("rate=").append(this.rate);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueDescPropMinRateVer14 other = (OFQueueDescPropMinRateVer14)obj;
        return this.rate == other.rate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rate;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueDescPropMinRateVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFQueueDescPropMinRateVer14 message) {
            bb.writeShort(1);
            bb.writeShort(8);
            bb.writeShort((int)U16.t(message.rate));
            bb.writeZero(2);
        }
    }

    static class OFQueueDescPropMinRateVer14Funnel
    implements Funnel<OFQueueDescPropMinRateVer14> {
        private static final long serialVersionUID = 1L;

        OFQueueDescPropMinRateVer14Funnel() {
        }

        public void funnel(OFQueueDescPropMinRateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)8);
            sink.putInt(message.rate);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueDescPropMinRate> {
        Reader() {
        }

        @Override
        public OFQueueDescPropMinRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int rate = U16.f(bb.readShort());
            bb.skipBytes(2);
            OFQueueDescPropMinRateVer14 queueDescPropMinRateVer14 = new OFQueueDescPropMinRateVer14(rate);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueDescPropMinRateVer14);
            }
            return queueDescPropMinRateVer14;
        }
    }

    static class Builder
    implements OFQueueDescPropMinRate.Builder {
        private boolean rateSet;
        private int rate;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueueDescPropMinRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFQueueDescPropMinRate build() {
            int rate = this.rateSet ? this.rate : 0;
            return new OFQueueDescPropMinRateVer14(rate);
        }
    }

    static class BuilderWithParent
    implements OFQueueDescPropMinRate.Builder {
        final OFQueueDescPropMinRateVer14 parentMessage;
        private boolean rateSet;
        private int rate;

        BuilderWithParent(OFQueueDescPropMinRateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueueDescPropMinRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFQueueDescPropMinRate build() {
            int rate = this.rateSet ? this.rate : this.parentMessage.rate;
            return new OFQueueDescPropMinRateVer14(rate);
        }
    }
}

