/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortModPropOptical;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortModPropOpticalVer14
implements OFPortModPropOptical {
    private static final Logger logger = LoggerFactory.getLogger(OFPortModPropOpticalVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final long DEFAULT_CONFIGURE = 0L;
    private static final long DEFAULT_FREQ_LDMA = 0L;
    private static final long DEFAULT_FL_OFFSET = 0L;
    private static final long DEFAULT_GRID_SPAN = 0L;
    private static final long DEFAULT_TX_PWR = 0L;
    private final long configure;
    private final long freqLdma;
    private final long flOffset;
    private final long gridSpan;
    private final long txPwr;
    static final OFPortModPropOpticalVer14 DEFAULT = new OFPortModPropOpticalVer14(0L, 0L, 0L, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFPortModPropOpticalVer14Funnel FUNNEL = new OFPortModPropOpticalVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortModPropOpticalVer14(long configure, long freqLdma, long flOffset, long gridSpan, long txPwr) {
        this.configure = U32.normalize(configure);
        this.freqLdma = U32.normalize(freqLdma);
        this.flOffset = U32.normalize(flOffset);
        this.gridSpan = U32.normalize(gridSpan);
        this.txPwr = U32.normalize(txPwr);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public long getConfigure() {
        return this.configure;
    }

    @Override
    public long getFreqLdma() {
        return this.freqLdma;
    }

    @Override
    public long getFlOffset() {
        return this.flOffset;
    }

    @Override
    public long getGridSpan() {
        return this.gridSpan;
    }

    @Override
    public long getTxPwr() {
        return this.txPwr;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortModPropOptical.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortModPropOpticalVer14(");
        b.append("configure=").append(this.configure);
        b.append(", ");
        b.append("freqLdma=").append(this.freqLdma);
        b.append(", ");
        b.append("flOffset=").append(this.flOffset);
        b.append(", ");
        b.append("gridSpan=").append(this.gridSpan);
        b.append(", ");
        b.append("txPwr=").append(this.txPwr);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModPropOpticalVer14 other = (OFPortModPropOpticalVer14)obj;
        if (this.configure != other.configure) {
            return false;
        }
        if (this.freqLdma != other.freqLdma) {
            return false;
        }
        if (this.flOffset != other.flOffset) {
            return false;
        }
        if (this.gridSpan != other.gridSpan) {
            return false;
        }
        return this.txPwr == other.txPwr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.configure ^ this.configure >>> 32);
        result = 31 * (int)(this.freqLdma ^ this.freqLdma >>> 32);
        result = 31 * (int)(this.flOffset ^ this.flOffset >>> 32);
        result = 31 * (int)(this.gridSpan ^ this.gridSpan >>> 32);
        result = 31 * (int)(this.txPwr ^ this.txPwr >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortModPropOpticalVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortModPropOpticalVer14 message) {
            bb.writeShort(1);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.configure));
            bb.writeInt(U32.t(message.freqLdma));
            bb.writeInt(U32.t(message.flOffset));
            bb.writeInt(U32.t(message.gridSpan));
            bb.writeInt(U32.t(message.txPwr));
        }
    }

    static class OFPortModPropOpticalVer14Funnel
    implements Funnel<OFPortModPropOpticalVer14> {
        private static final long serialVersionUID = 1L;

        OFPortModPropOpticalVer14Funnel() {
        }

        public void funnel(OFPortModPropOpticalVer14 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)24);
            sink.putLong(message.configure);
            sink.putLong(message.freqLdma);
            sink.putLong(message.flOffset);
            sink.putLong(message.gridSpan);
            sink.putLong(message.txPwr);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortModPropOptical> {
        Reader() {
        }

        @Override
        public OFPortModPropOptical readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long configure = U32.f(bb.readInt());
            long freqLdma = U32.f(bb.readInt());
            long flOffset = U32.f(bb.readInt());
            long gridSpan = U32.f(bb.readInt());
            long txPwr = U32.f(bb.readInt());
            OFPortModPropOpticalVer14 portModPropOpticalVer14 = new OFPortModPropOpticalVer14(configure, freqLdma, flOffset, gridSpan, txPwr);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portModPropOpticalVer14);
            }
            return portModPropOpticalVer14;
        }
    }

    static class Builder
    implements OFPortModPropOptical.Builder {
        private boolean configureSet;
        private long configure;
        private boolean freqLdmaSet;
        private long freqLdma;
        private boolean flOffsetSet;
        private long flOffset;
        private boolean gridSpanSet;
        private long gridSpan;
        private boolean txPwrSet;
        private long txPwr;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getConfigure() {
            return this.configure;
        }

        @Override
        public OFPortModPropOptical.Builder setConfigure(long configure) {
            this.configure = configure;
            this.configureSet = true;
            return this;
        }

        @Override
        public long getFreqLdma() {
            return this.freqLdma;
        }

        @Override
        public OFPortModPropOptical.Builder setFreqLdma(long freqLdma) {
            this.freqLdma = freqLdma;
            this.freqLdmaSet = true;
            return this;
        }

        @Override
        public long getFlOffset() {
            return this.flOffset;
        }

        @Override
        public OFPortModPropOptical.Builder setFlOffset(long flOffset) {
            this.flOffset = flOffset;
            this.flOffsetSet = true;
            return this;
        }

        @Override
        public long getGridSpan() {
            return this.gridSpan;
        }

        @Override
        public OFPortModPropOptical.Builder setGridSpan(long gridSpan) {
            this.gridSpan = gridSpan;
            this.gridSpanSet = true;
            return this;
        }

        @Override
        public long getTxPwr() {
            return this.txPwr;
        }

        @Override
        public OFPortModPropOptical.Builder setTxPwr(long txPwr) {
            this.txPwr = txPwr;
            this.txPwrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortModPropOptical build() {
            long configure = this.configureSet ? this.configure : 0L;
            long freqLdma = this.freqLdmaSet ? this.freqLdma : 0L;
            long flOffset = this.flOffsetSet ? this.flOffset : 0L;
            long gridSpan = this.gridSpanSet ? this.gridSpan : 0L;
            long txPwr = this.txPwrSet ? this.txPwr : 0L;
            return new OFPortModPropOpticalVer14(configure, freqLdma, flOffset, gridSpan, txPwr);
        }
    }

    static class BuilderWithParent
    implements OFPortModPropOptical.Builder {
        final OFPortModPropOpticalVer14 parentMessage;
        private boolean configureSet;
        private long configure;
        private boolean freqLdmaSet;
        private long freqLdma;
        private boolean flOffsetSet;
        private long flOffset;
        private boolean gridSpanSet;
        private long gridSpan;
        private boolean txPwrSet;
        private long txPwr;

        BuilderWithParent(OFPortModPropOpticalVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getConfigure() {
            return this.configure;
        }

        @Override
        public OFPortModPropOptical.Builder setConfigure(long configure) {
            this.configure = configure;
            this.configureSet = true;
            return this;
        }

        @Override
        public long getFreqLdma() {
            return this.freqLdma;
        }

        @Override
        public OFPortModPropOptical.Builder setFreqLdma(long freqLdma) {
            this.freqLdma = freqLdma;
            this.freqLdmaSet = true;
            return this;
        }

        @Override
        public long getFlOffset() {
            return this.flOffset;
        }

        @Override
        public OFPortModPropOptical.Builder setFlOffset(long flOffset) {
            this.flOffset = flOffset;
            this.flOffsetSet = true;
            return this;
        }

        @Override
        public long getGridSpan() {
            return this.gridSpan;
        }

        @Override
        public OFPortModPropOptical.Builder setGridSpan(long gridSpan) {
            this.gridSpan = gridSpan;
            this.gridSpanSet = true;
            return this;
        }

        @Override
        public long getTxPwr() {
            return this.txPwr;
        }

        @Override
        public OFPortModPropOptical.Builder setTxPwr(long txPwr) {
            this.txPwr = txPwr;
            this.txPwrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortModPropOptical build() {
            long configure = this.configureSet ? this.configure : this.parentMessage.configure;
            long freqLdma = this.freqLdmaSet ? this.freqLdma : this.parentMessage.freqLdma;
            long flOffset = this.flOffsetSet ? this.flOffset : this.parentMessage.flOffset;
            long gridSpan = this.gridSpanSet ? this.gridSpan : this.parentMessage.gridSpan;
            long txPwr = this.txPwrSet ? this.txPwr : this.parentMessage.txPwr;
            return new OFPortModPropOpticalVer14(configure, freqLdma, flOffset, gridSpan, txPwr);
        }
    }
}

