/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmSctpDst;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmSctpDstVer14
implements OFOxmSctpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmSctpDstVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private final TransportPort value;
    static final OFOxmSctpDstVer14 DEFAULT = new OFOxmSctpDstVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmSctpDstVer14Funnel FUNNEL = new OFOxmSctpDstVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmSctpDstVer14(TransportPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmSctpDstVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147492866L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.SCTP_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        return this;
    }

    @Override
    public TransportPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmSctpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmSctpDstVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmSctpDstVer14 other = (OFOxmSctpDstVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmSctpDstVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmSctpDstVer14 message) {
            bb.writeInt(-2147474430);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmSctpDstVer14Funnel
    implements Funnel<OFOxmSctpDstVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmSctpDstVer14Funnel() {
        }

        public void funnel(OFOxmSctpDstVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147474430);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmSctpDst> {
        Reader() {
        }

        @Override
        public OFOxmSctpDst readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147474430) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002402L(0x80002402L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            OFOxmSctpDstVer14 oxmSctpDstVer14 = new OFOxmSctpDstVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmSctpDstVer14);
            }
            return oxmSctpDstVer14;
        }
    }

    static class Builder
    implements OFOxmSctpDst.Builder {
        private boolean valueSet;
        private TransportPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147492866L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmSctpDst.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.SCTP_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmSctpDst build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmSctpDstVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmSctpDst.Builder {
        final OFOxmSctpDstVer14 parentMessage;
        private boolean valueSet;
        private TransportPort value;

        BuilderWithParent(OFOxmSctpDstVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147492866L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmSctpDst.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.SCTP_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmSctpDst build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmSctpDstVer14(value);
        }
    }
}

