/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVrf;
import org.projectfloodlight.openflow.types.VRF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVrfVer14
implements OFOxmBsnVrf {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVrfVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final VRF DEFAULT_VALUE = VRF.ZERO;
    private final VRF value;
    static final OFOxmBsnVrfVer14 DEFAULT = new OFOxmBsnVrfVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnVrfVer14Funnel FUNNEL = new OFOxmBsnVrfVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVrfVer14(VRF value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVrfVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 197636L;
    }

    @Override
    public VRF getValue() {
        return this.value;
    }

    @Override
    public MatchField<VRF> getMatchField() {
        return MatchField.BSN_VRF;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<VRF> getCanonical() {
        return this;
    }

    @Override
    public VRF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnVrf.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVrfVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVrfVer14 other = (OFOxmBsnVrfVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVrfVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVrfVer14 message) {
            bb.writeInt(197636);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVrfVer14Funnel
    implements Funnel<OFOxmBsnVrfVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVrfVer14Funnel() {
        }

        public void funnel(OFOxmBsnVrfVer14 message, PrimitiveSink sink) {
            sink.putInt(197636);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVrf> {
        Reader() {
        }

        @Override
        public OFOxmBsnVrf readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197636) {
                throw new OFParseError("Wrong typeLen: Expected=0x30404L(0x30404L), got=" + typeLen);
            }
            VRF value = VRF.read4Bytes(bb);
            OFOxmBsnVrfVer14 oxmBsnVrfVer14 = new OFOxmBsnVrfVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVrfVer14);
            }
            return oxmBsnVrfVer14;
        }
    }

    static class Builder
    implements OFOxmBsnVrf.Builder {
        private boolean valueSet;
        private VRF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197636L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrf.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public VRF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVrf build() {
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVrfVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVrf.Builder {
        final OFOxmBsnVrfVer14 parentMessage;
        private boolean valueSet;
        private VRF value;

        BuilderWithParent(OFOxmBsnVrfVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197636L;
        }

        @Override
        public VRF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVrf.Builder setValue(VRF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<VRF> getMatchField() {
            return MatchField.BSN_VRF;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<VRF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public VRF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVrf build() {
            VRF value;
            VRF vRF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnVrfVer14(value);
        }
    }
}

