/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVfiMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmBsnVfiVer14;
import org.projectfloodlight.openflow.types.VFI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVfiMaskedVer14
implements OFOxmBsnVfiMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVfiMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final VFI DEFAULT_VALUE = VFI.ZERO;
    private static final VFI DEFAULT_VALUE_MASK = VFI.ZERO;
    private final VFI value;
    private final VFI mask;
    static final OFOxmBsnVfiMaskedVer14 DEFAULT = new OFOxmBsnVfiMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnVfiMaskedVer14Funnel FUNNEL = new OFOxmBsnVfiMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVfiMaskedVer14(VFI value, VFI mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVfiMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnVfiMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 209668L;
    }

    @Override
    public VFI getValue() {
        return this.value;
    }

    @Override
    public VFI getMask() {
        return this.mask;
    }

    @Override
    public MatchField<VFI> getMatchField() {
        return MatchField.BSN_VFI;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<VFI> getCanonical() {
        if (VFI.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnVfiVer14(this.value);
        }
        if (VFI.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnVfiMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVfiMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVfiMaskedVer14 other = (OFOxmBsnVfiMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVfiMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVfiMaskedVer14 message) {
            bb.writeInt(209668);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmBsnVfiMaskedVer14Funnel
    implements Funnel<OFOxmBsnVfiMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVfiMaskedVer14Funnel() {
        }

        public void funnel(OFOxmBsnVfiMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(209668);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVfiMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnVfiMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 209668) {
                throw new OFParseError("Wrong typeLen: Expected=0x33304L(0x33304L), got=" + typeLen);
            }
            VFI value = VFI.read2Bytes(bb);
            VFI mask = VFI.read2Bytes(bb);
            OFOxmBsnVfiMaskedVer14 oxmBsnVfiMaskedVer14 = new OFOxmBsnVfiMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVfiMaskedVer14);
            }
            return oxmBsnVfiMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmBsnVfiMasked.Builder {
        private boolean valueSet;
        private VFI value;
        private boolean maskSet;
        private VFI mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 209668L;
        }

        @Override
        public VFI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVfiMasked.Builder setValue(VFI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VFI getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVfiMasked.Builder setMask(VFI mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VFI> getMatchField() {
            return MatchField.BSN_VFI;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VFI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVfiMasked build() {
            VFI mask;
            VFI value;
            VFI vFI = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VFI vFI2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVfiMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVfiMasked.Builder {
        final OFOxmBsnVfiMaskedVer14 parentMessage;
        private boolean valueSet;
        private VFI value;
        private boolean maskSet;
        private VFI mask;

        BuilderWithParent(OFOxmBsnVfiMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 209668L;
        }

        @Override
        public VFI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVfiMasked.Builder setValue(VFI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VFI getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVfiMasked.Builder setMask(VFI mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VFI> getMatchField() {
            return MatchField.BSN_VFI;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VFI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnVfiMasked build() {
            VFI mask;
            VFI value;
            VFI vFI = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VFI vFI2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVfiMaskedVer14(value, mask);
        }
    }
}

