/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.errormsg.OFExperimenterErrorMsg;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnBaseErrorVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFExperimenterErrorMsgVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFExperimenterErrorMsgVer14() {
    }

    static class Reader
    implements OFMessageReader<OFExperimenterErrorMsg> {
        Reader() {
        }

        @Override
        public OFExperimenterErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != -1) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.EXPERIMENTER(65535), got=" + errType);
            }
            U16.f(bb.readShort());
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFBsnBaseErrorVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFExperimenterErrorMsgVer14: " + experimenter);
        }
    }
}

