/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleCtrlType;

public class OFBundleCtrlTypeSerializerVer14 {
    public static final short OPEN_REQUEST_VAL = 0;
    public static final short OPEN_REPLY_VAL = 1;
    public static final short CLOSE_REQUEST_VAL = 2;
    public static final short CLOSE_REPLY_VAL = 3;
    public static final short COMMIT_REQUEST_VAL = 4;
    public static final short COMMIT_REPLY_VAL = 5;
    public static final short DISCARD_REQUEST_VAL = 6;
    public static final short DISCARD_REPLY_VAL = 7;

    public static OFBundleCtrlType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBundleCtrlTypeSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFBundleCtrlType e) {
        bb.writeShort((int)OFBundleCtrlTypeSerializerVer14.toWireValue(e));
    }

    public static void putTo(OFBundleCtrlType e, PrimitiveSink sink) {
        sink.putShort(OFBundleCtrlTypeSerializerVer14.toWireValue(e));
    }

    public static OFBundleCtrlType ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFBundleCtrlType.OPEN_REQUEST;
            }
            case 1: {
                return OFBundleCtrlType.OPEN_REPLY;
            }
            case 2: {
                return OFBundleCtrlType.CLOSE_REQUEST;
            }
            case 3: {
                return OFBundleCtrlType.CLOSE_REPLY;
            }
            case 4: {
                return OFBundleCtrlType.COMMIT_REQUEST;
            }
            case 5: {
                return OFBundleCtrlType.COMMIT_REPLY;
            }
            case 6: {
                return OFBundleCtrlType.DISCARD_REQUEST;
            }
            case 7: {
                return OFBundleCtrlType.DISCARD_REPLY;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFBundleCtrlType in version 1.4: " + val);
    }

    public static short toWireValue(OFBundleCtrlType e) {
        switch (e) {
            case OPEN_REQUEST: {
                return 0;
            }
            case OPEN_REPLY: {
                return 1;
            }
            case CLOSE_REQUEST: {
                return 2;
            }
            case CLOSE_REPLY: {
                return 3;
            }
            case COMMIT_REQUEST: {
                return 4;
            }
            case COMMIT_REPLY: {
                return 5;
            }
            case DISCARD_REQUEST: {
                return 6;
            }
            case DISCARD_REPLY: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFBundleCtrlType in version 1.4: " + (Object)((Object)e));
    }
}

