/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVirtualPortRemoveRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVirtualPortRemoveRequestVer14
implements OFBsnVirtualPortRemoveRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVirtualPortRemoveRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_VPORT_NO = 0L;
    private final long xid;
    private final long vportNo;
    static final OFBsnVirtualPortRemoveRequestVer14 DEFAULT = new OFBsnVirtualPortRemoveRequestVer14(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnVirtualPortRemoveRequestVer14Funnel FUNNEL = new OFBsnVirtualPortRemoveRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVirtualPortRemoveRequestVer14(long xid, long vportNo) {
        this.xid = U32.normalize(xid);
        this.vportNo = U32.normalize(vportNo);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 17L;
    }

    @Override
    public long getVportNo() {
        return this.vportNo;
    }

    @Override
    public OFBsnVirtualPortRemoveRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVirtualPortRemoveRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("vportNo=").append(this.vportNo);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVirtualPortRemoveRequestVer14 other = (OFBsnVirtualPortRemoveRequestVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return this.vportNo == other.vportNo;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVirtualPortRemoveRequestVer14 other = (OFBsnVirtualPortRemoveRequestVer14)obj;
        return this.vportNo == other.vportNo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.vportNo ^ this.vportNo >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.vportNo ^ this.vportNo >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVirtualPortRemoveRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVirtualPortRemoveRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(4);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(17);
            bb.writeInt(U32.t(message.vportNo));
        }
    }

    static class OFBsnVirtualPortRemoveRequestVer14Funnel
    implements Funnel<OFBsnVirtualPortRemoveRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnVirtualPortRemoveRequestVer14Funnel() {
        }

        public void funnel(OFBsnVirtualPortRemoveRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)4);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(17);
            sink.putLong(message.vportNo);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVirtualPortRemoveRequest> {
        Reader() {
        }

        @Override
        public OFBsnVirtualPortRemoveRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 17) {
                throw new OFParseError("Wrong subtype: Expected=0x11L(0x11L), got=" + subtype);
            }
            long vportNo = U32.f(bb.readInt());
            OFBsnVirtualPortRemoveRequestVer14 bsnVirtualPortRemoveRequestVer14 = new OFBsnVirtualPortRemoveRequestVer14(xid, vportNo);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVirtualPortRemoveRequestVer14);
            }
            return bsnVirtualPortRemoveRequestVer14;
        }
    }

    static class Builder
    implements OFBsnVirtualPortRemoveRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean vportNoSet;
        private long vportNo;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVirtualPortRemoveRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 17L;
        }

        @Override
        public long getVportNo() {
            return this.vportNo;
        }

        @Override
        public OFBsnVirtualPortRemoveRequest.Builder setVportNo(long vportNo) {
            this.vportNo = vportNo;
            this.vportNoSet = true;
            return this;
        }

        @Override
        public OFBsnVirtualPortRemoveRequest build() {
            long xid = this.xidSet ? this.xid : 0L;
            long vportNo = this.vportNoSet ? this.vportNo : 0L;
            return new OFBsnVirtualPortRemoveRequestVer14(xid, vportNo);
        }
    }

    static class BuilderWithParent
    implements OFBsnVirtualPortRemoveRequest.Builder {
        final OFBsnVirtualPortRemoveRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean vportNoSet;
        private long vportNo;

        BuilderWithParent(OFBsnVirtualPortRemoveRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVirtualPortRemoveRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 17L;
        }

        @Override
        public long getVportNo() {
            return this.vportNo;
        }

        @Override
        public OFBsnVirtualPortRemoveRequest.Builder setVportNo(long vportNo) {
            this.vportNo = vportNo;
            this.vportNoSet = true;
            return this;
        }

        @Override
        public OFBsnVirtualPortRemoveRequest build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long vportNo = this.vportNoSet ? this.vportNo : this.parentMessage.vportNo;
            return new OFBsnVirtualPortRemoveRequestVer14(xid, vportNo);
        }
    }
}

