/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUdfId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUdfIdVer14
implements OFBsnTlvUdfId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUdfIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvUdfIdVer14 DEFAULT = new OFBsnTlvUdfIdVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUdfIdVer14Funnel FUNNEL = new OFBsnTlvUdfIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUdfIdVer14(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvUdfId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUdfIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUdfIdVer14 other = (OFBsnTlvUdfIdVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUdfIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUdfIdVer14 message) {
            bb.writeShort(15);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvUdfIdVer14Funnel
    implements Funnel<OFBsnTlvUdfIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUdfIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvUdfIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)15);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUdfId> {
        Reader() {
        }

        @Override
        public OFBsnTlvUdfId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 15) {
                throw new OFParseError("Wrong type: Expected=0xf(0xf), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvUdfIdVer14 bsnTlvUdfIdVer14 = new OFBsnTlvUdfIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUdfIdVer14);
            }
            return bsnTlvUdfIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvUdfId.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 15;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdfId.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUdfId build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvUdfIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUdfId.Builder {
        final OFBsnTlvUdfIdVer14 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvUdfIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 15;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdfId.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUdfId build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUdfIdVer14(value);
        }
    }
}

