/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRemoteId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRemoteIdVer14
implements OFBsnTlvRemoteId {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRemoteIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private final byte[] value;
    static final OFBsnTlvRemoteIdVer14 DEFAULT = new OFBsnTlvRemoteIdVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvRemoteIdVer14Funnel FUNNEL = new OFBsnTlvRemoteIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRemoteIdVer14(byte[] value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRemoteIdVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 224;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvRemoteId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRemoteIdVer14(");
        b.append("value=").append(Arrays.toString(this.value));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRemoteIdVer14 other = (OFBsnTlvRemoteIdVer14)obj;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRemoteIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRemoteIdVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(224);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.value);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnTlvRemoteIdVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvRemoteIdVer14Funnel
    implements Funnel<OFBsnTlvRemoteIdVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRemoteIdVer14Funnel() {
        }

        public void funnel(OFBsnTlvRemoteIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)224);
            sink.putBytes(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRemoteId> {
        Reader() {
        }

        @Override
        public OFBsnTlvRemoteId readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 224) {
                throw new OFParseError("Wrong type: Expected=0xe0(0xe0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] value = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnTlvRemoteIdVer14 bsnTlvRemoteIdVer14 = new OFBsnTlvRemoteIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRemoteIdVer14);
            }
            return bsnTlvRemoteIdVer14;
        }
    }

    static class Builder
    implements OFBsnTlvRemoteId.Builder {
        private boolean valueSet;
        private byte[] value;

        Builder() {
        }

        @Override
        public int getType() {
            return 224;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRemoteId.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRemoteId build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRemoteIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRemoteId.Builder {
        final OFBsnTlvRemoteIdVer14 parentMessage;
        private boolean valueSet;
        private byte[] value;

        BuilderWithParent(OFBsnTlvRemoteIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 224;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRemoteId.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvRemoteId build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRemoteIdVer14(value);
        }
    }
}

