/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLagType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLagType;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnLagTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLagTypeVer14
implements OFBsnTlvLagType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLagTypeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private final OFBsnLagType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvLagTypeVer14Funnel FUNNEL = new OFBsnTlvLagTypeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLagTypeVer14(OFBsnLagType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvLagTypeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 227;
    }

    @Override
    public OFBsnLagType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvLagType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLagTypeVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLagTypeVer14 other = (OFBsnTlvLagTypeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLagTypeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLagTypeVer14 message) {
            bb.writeShort(227);
            bb.writeShort(6);
            OFBsnLagTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvLagTypeVer14Funnel
    implements Funnel<OFBsnTlvLagTypeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLagTypeVer14Funnel() {
        }

        public void funnel(OFBsnTlvLagTypeVer14 message, PrimitiveSink sink) {
            sink.putShort((short)227);
            sink.putShort((short)6);
            OFBsnLagTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLagType> {
        Reader() {
        }

        @Override
        public OFBsnTlvLagType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 227) {
                throw new OFParseError("Wrong type: Expected=0xe3(0xe3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnLagType value = OFBsnLagTypeSerializerVer14.readFrom(bb);
            OFBsnTlvLagTypeVer14 bsnTlvLagTypeVer14 = new OFBsnTlvLagTypeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLagTypeVer14);
            }
            return bsnTlvLagTypeVer14;
        }
    }

    static class Builder
    implements OFBsnTlvLagType.Builder {
        private boolean valueSet;
        private OFBsnLagType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 227;
        }

        @Override
        public OFBsnLagType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLagType.Builder setValue(OFBsnLagType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvLagType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLagTypeVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLagType.Builder {
        final OFBsnTlvLagTypeVer14 parentMessage;
        private boolean valueSet;
        private OFBsnLagType value;

        BuilderWithParent(OFBsnTlvLagTypeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 227;
        }

        @Override
        public OFBsnLagType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLagType.Builder setValue(OFBsnLagType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvLagType build() {
            OFBsnLagType value;
            OFBsnLagType oFBsnLagType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLagTypeVer14(value);
        }
    }
}

