/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsRequestFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableBucketStatsRequestVer14
implements OFBsnGentableBucketStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableBucketStatsRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 26;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final GenTableId tableId;
    static final Reader READER = new Reader();
    static final OFBsnGentableBucketStatsRequestVer14Funnel FUNNEL = new OFBsnGentableBucketStatsRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableBucketStatsRequestVer14(long xid, Set<OFStatsRequestFlags> flags, GenTableId tableId) {
        if (flags == null) {
            throw new NullPointerException("OFBsnGentableBucketStatsRequestVer14: property flags cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableBucketStatsRequestVer14: property tableId cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.tableId = tableId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 5L;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFBsnGentableBucketStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableBucketStatsRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableBucketStatsRequestVer14 other = (OFBsnGentableBucketStatsRequestVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableBucketStatsRequestVer14 other = (OFBsnGentableBucketStatsRequestVer14)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableBucketStatsRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableBucketStatsRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(18);
            bb.writeShort(26);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(5);
            message.tableId.write2Bytes(bb);
        }
    }

    static class OFBsnGentableBucketStatsRequestVer14Funnel
    implements Funnel<OFBsnGentableBucketStatsRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableBucketStatsRequestVer14Funnel() {
        }

        public void funnel(OFBsnGentableBucketStatsRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)18);
            sink.putShort((short)26);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer14.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(5);
            message.tableId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableBucketStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnGentableBucketStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 26) {
                throw new OFParseError("Wrong length: Expected=26(26), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 5) {
                throw new OFParseError("Wrong subtype: Expected=0x5L(0x5L), got=" + subtype);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            OFBsnGentableBucketStatsRequestVer14 bsnGentableBucketStatsRequestVer14 = new OFBsnGentableBucketStatsRequestVer14(xid, flags, tableId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableBucketStatsRequestVer14);
            }
            return bsnGentableBucketStatsRequestVer14;
        }
    }

    static class Builder
    implements OFBsnGentableBucketStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private GenTableId tableId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableBucketStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGentableBucketStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 5L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableBucketStatsRequest.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFBsnGentableBucketStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            return new OFBsnGentableBucketStatsRequestVer14(xid, flags, this.tableId);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableBucketStatsRequest.Builder {
        final OFBsnGentableBucketStatsRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private GenTableId tableId;

        BuilderWithParent(OFBsnGentableBucketStatsRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableBucketStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGentableBucketStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 5L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableBucketStatsRequest.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFBsnGentableBucketStatsRequest build() {
            GenTableId tableId;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            return new OFBsnGentableBucketStatsRequestVer14(xid, flags, tableId);
        }
    }
}

