/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropNextTables;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropNextTablesVer13
implements OFTableFeaturePropNextTables {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropNextTablesVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<U8> DEFAULT_NEXT_TABLE_IDS = ImmutableList.of();
    private final List<U8> nextTableIds;
    static final OFTableFeaturePropNextTablesVer13 DEFAULT = new OFTableFeaturePropNextTablesVer13(DEFAULT_NEXT_TABLE_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropNextTablesVer13Funnel FUNNEL = new OFTableFeaturePropNextTablesVer13Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropNextTablesVer13(List<U8> nextTableIds) {
        if (nextTableIds == null) {
            throw new NullPointerException("OFTableFeaturePropNextTablesVer13: property nextTableIds cannot be null");
        }
        this.nextTableIds = nextTableIds;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public List<U8> getNextTableIds() {
        return this.nextTableIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFTableFeaturePropNextTables.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropNextTablesVer13(");
        b.append("nextTableIds=").append(this.nextTableIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropNextTablesVer13 other = (OFTableFeaturePropNextTablesVer13)obj;
        return !(this.nextTableIds == null ? other.nextTableIds != null : !this.nextTableIds.equals(other.nextTableIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nextTableIds == null ? 0 : this.nextTableIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropNextTablesVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropNextTablesVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(2);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.nextTableIds);
            int length = bb.writerIndex() - startIndex;
            int alignedLength = (length + 7) / 8 * 8;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableFeaturePropNextTablesVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
            bb.writeZero(alignedLength - length);
        }
    }

    static class OFTableFeaturePropNextTablesVer13Funnel
    implements Funnel<OFTableFeaturePropNextTablesVer13> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropNextTablesVer13Funnel() {
        }

        public void funnel(OFTableFeaturePropNextTablesVer13 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            FunnelUtils.putList(message.nextTableIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropNextTables> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropNextTables readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=0x2(0x2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U8> nextTableIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U8.READER);
            bb.skipBytes((length + 7) / 8 * 8 - length);
            OFTableFeaturePropNextTablesVer13 tableFeaturePropNextTablesVer13 = new OFTableFeaturePropNextTablesVer13(nextTableIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropNextTablesVer13);
            }
            return tableFeaturePropNextTablesVer13;
        }
    }

    static class Builder
    implements OFTableFeaturePropNextTables.Builder {
        private boolean nextTableIdsSet;
        private List<U8> nextTableIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public List<U8> getNextTableIds() {
            return this.nextTableIds;
        }

        @Override
        public OFTableFeaturePropNextTables.Builder setNextTableIds(List<U8> nextTableIds) {
            this.nextTableIds = nextTableIds;
            this.nextTableIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropNextTables build() {
            List<U8> nextTableIds;
            List<U8> list = nextTableIds = this.nextTableIdsSet ? this.nextTableIds : DEFAULT_NEXT_TABLE_IDS;
            if (nextTableIds == null) {
                throw new NullPointerException("Property nextTableIds must not be null");
            }
            return new OFTableFeaturePropNextTablesVer13(nextTableIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropNextTables.Builder {
        final OFTableFeaturePropNextTablesVer13 parentMessage;
        private boolean nextTableIdsSet;
        private List<U8> nextTableIds;

        BuilderWithParent(OFTableFeaturePropNextTablesVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public List<U8> getNextTableIds() {
            return this.nextTableIds;
        }

        @Override
        public OFTableFeaturePropNextTables.Builder setNextTableIds(List<U8> nextTableIds) {
            this.nextTableIds = nextTableIds;
            this.nextTableIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFTableFeaturePropNextTables build() {
            List nextTableIds;
            List list = nextTableIds = this.nextTableIdsSet ? this.nextTableIds : this.parentMessage.nextTableIds;
            if (nextTableIds == null) {
                throw new NullPointerException("Property nextTableIds must not be null");
            }
            return new OFTableFeaturePropNextTablesVer13(nextTableIds);
        }
    }
}

