/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnIngressPortGroupId;
import org.projectfloodlight.openflow.types.ClassId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnIngressPortGroupIdVer13
implements OFOxmBsnIngressPortGroupId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnIngressPortGroupIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final ClassId DEFAULT_VALUE = ClassId.NONE;
    private final ClassId value;
    static final OFOxmBsnIngressPortGroupIdVer13 DEFAULT = new OFOxmBsnIngressPortGroupIdVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnIngressPortGroupIdVer13Funnel FUNNEL = new OFOxmBsnIngressPortGroupIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnIngressPortGroupIdVer13(ClassId value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnIngressPortGroupIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 206852L;
    }

    @Override
    public ClassId getValue() {
        return this.value;
    }

    @Override
    public MatchField<ClassId> getMatchField() {
        return MatchField.BSN_INGRESS_PORT_GROUP_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<ClassId> getCanonical() {
        return this;
    }

    @Override
    public ClassId getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnIngressPortGroupId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnIngressPortGroupIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnIngressPortGroupIdVer13 other = (OFOxmBsnIngressPortGroupIdVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnIngressPortGroupIdVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnIngressPortGroupIdVer13 message) {
            bb.writeInt(206852);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnIngressPortGroupIdVer13Funnel
    implements Funnel<OFOxmBsnIngressPortGroupIdVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnIngressPortGroupIdVer13Funnel() {
        }

        public void funnel(OFOxmBsnIngressPortGroupIdVer13 message, PrimitiveSink sink) {
            sink.putInt(206852);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnIngressPortGroupId> {
        Reader() {
        }

        @Override
        public OFOxmBsnIngressPortGroupId readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 206852) {
                throw new OFParseError("Wrong typeLen: Expected=0x32804L(0x32804L), got=" + typeLen);
            }
            ClassId value = ClassId.read4Bytes(bb);
            OFOxmBsnIngressPortGroupIdVer13 oxmBsnIngressPortGroupIdVer13 = new OFOxmBsnIngressPortGroupIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnIngressPortGroupIdVer13);
            }
            return oxmBsnIngressPortGroupIdVer13;
        }
    }

    static class Builder
    implements OFOxmBsnIngressPortGroupId.Builder {
        private boolean valueSet;
        private ClassId value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 206852L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIngressPortGroupId.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_INGRESS_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public ClassId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnIngressPortGroupId build() {
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnIngressPortGroupIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnIngressPortGroupId.Builder {
        final OFOxmBsnIngressPortGroupIdVer13 parentMessage;
        private boolean valueSet;
        private ClassId value;

        BuilderWithParent(OFOxmBsnIngressPortGroupIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 206852L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIngressPortGroupId.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_INGRESS_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public ClassId getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnIngressPortGroupId build() {
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnIngressPortGroupIdVer13(value);
        }
    }
}

