/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvParentPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvParentPortVer13
implements OFBsnTlvParentPort {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvParentPortVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFBsnTlvParentPortVer13 DEFAULT = new OFBsnTlvParentPortVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvParentPortVer13Funnel FUNNEL = new OFBsnTlvParentPortVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvParentPortVer13(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvParentPortVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 109;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvParentPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvParentPortVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvParentPortVer13 other = (OFBsnTlvParentPortVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvParentPortVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvParentPortVer13 message) {
            bb.writeShort(109);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvParentPortVer13Funnel
    implements Funnel<OFBsnTlvParentPortVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvParentPortVer13Funnel() {
        }

        public void funnel(OFBsnTlvParentPortVer13 message, PrimitiveSink sink) {
            sink.putShort((short)109);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvParentPort> {
        Reader() {
        }

        @Override
        public OFBsnTlvParentPort readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 109) {
                throw new OFParseError("Wrong type: Expected=0x6d(0x6d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFBsnTlvParentPortVer13 bsnTlvParentPortVer13 = new OFBsnTlvParentPortVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvParentPortVer13);
            }
            return bsnTlvParentPortVer13;
        }
    }

    static class Builder
    implements OFBsnTlvParentPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public int getType() {
            return 109;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvParentPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvParentPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvParentPortVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvParentPort.Builder {
        final OFBsnTlvParentPortVer13 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFBsnTlvParentPortVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 109;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvParentPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvParentPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvParentPortVer13(value);
        }
    }
}

