/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionPushVlan;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionPushVlanVer13
implements OFActionPushVlan {
    private static final Logger logger = LoggerFactory.getLogger(OFActionPushVlanVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final EthType DEFAULT_ETHERTYPE = EthType.NONE;
    private final EthType ethertype;
    static final OFActionPushVlanVer13 DEFAULT = new OFActionPushVlanVer13(DEFAULT_ETHERTYPE);
    static final Reader READER = new Reader();
    static final OFActionPushVlanVer13Funnel FUNNEL = new OFActionPushVlanVer13Funnel();
    static final Writer WRITER = new Writer();

    OFActionPushVlanVer13(EthType ethertype) {
        if (ethertype == null) {
            throw new NullPointerException("OFActionPushVlanVer13: property ethertype cannot be null");
        }
        this.ethertype = ethertype;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.PUSH_VLAN;
    }

    @Override
    public EthType getEthertype() {
        return this.ethertype;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionPushVlan.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionPushVlanVer13(");
        b.append("ethertype=").append(this.ethertype);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionPushVlanVer13 other = (OFActionPushVlanVer13)obj;
        return !(this.ethertype == null ? other.ethertype != null : !this.ethertype.equals(other.ethertype));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ethertype == null ? 0 : this.ethertype.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionPushVlanVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionPushVlanVer13 message) {
            bb.writeShort(17);
            bb.writeShort(8);
            message.ethertype.write2Bytes(bb);
            bb.writeZero(2);
        }
    }

    static class OFActionPushVlanVer13Funnel
    implements Funnel<OFActionPushVlanVer13> {
        private static final long serialVersionUID = 1L;

        OFActionPushVlanVer13Funnel() {
        }

        public void funnel(OFActionPushVlanVer13 message, PrimitiveSink sink) {
            sink.putShort((short)17);
            sink.putShort((short)8);
            message.ethertype.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionPushVlan> {
        Reader() {
        }

        @Override
        public OFActionPushVlan readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 17) {
                throw new OFParseError("Wrong type: Expected=OFActionType.PUSH_VLAN(17), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            EthType ethertype = EthType.read2Bytes(bb);
            bb.skipBytes(2);
            OFActionPushVlanVer13 actionPushVlanVer13 = new OFActionPushVlanVer13(ethertype);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionPushVlanVer13);
            }
            return actionPushVlanVer13;
        }
    }

    static class Builder
    implements OFActionPushVlan.Builder {
        private boolean ethertypeSet;
        private EthType ethertype;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.PUSH_VLAN;
        }

        @Override
        public EthType getEthertype() {
            return this.ethertype;
        }

        @Override
        public OFActionPushVlan.Builder setEthertype(EthType ethertype) {
            this.ethertype = ethertype;
            this.ethertypeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionPushVlan build() {
            EthType ethertype;
            EthType ethType = ethertype = this.ethertypeSet ? this.ethertype : DEFAULT_ETHERTYPE;
            if (ethertype == null) {
                throw new NullPointerException("Property ethertype must not be null");
            }
            return new OFActionPushVlanVer13(ethertype);
        }
    }

    static class BuilderWithParent
    implements OFActionPushVlan.Builder {
        final OFActionPushVlanVer13 parentMessage;
        private boolean ethertypeSet;
        private EthType ethertype;

        BuilderWithParent(OFActionPushVlanVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.PUSH_VLAN;
        }

        @Override
        public EthType getEthertype() {
            return this.ethertype;
        }

        @Override
        public OFActionPushVlan.Builder setEthertype(EthType ethertype) {
            this.ethertype = ethertype;
            this.ethertypeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionPushVlan build() {
            EthType ethertype;
            EthType ethType = ethertype = this.ethertypeSet ? this.ethertype : this.parentMessage.ethertype;
            if (ethertype == null) {
                throw new NullPointerException("Property ethertype must not be null");
            }
            return new OFActionPushVlanVer13(ethertype);
        }
    }
}

