/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBucketCounter;
import org.projectfloodlight.openflow.protocol.OFGroupStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFBucketCounterVer11;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupStatsEntryVer11
implements OFGroupStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupStatsEntryVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 32;
    static final int MAXIMUM_LENGTH = 65535;
    private static final OFGroup DEFAULT_GROUP_ID = OFGroup.ALL;
    private static final long DEFAULT_REF_COUNT = 0L;
    private static final U64 DEFAULT_PACKET_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_COUNT = U64.ZERO;
    private static final List<OFBucketCounter> DEFAULT_BUCKET_STATS = ImmutableList.of();
    private final OFGroup group;
    private final long refCount;
    private final U64 packetCount;
    private final U64 byteCount;
    private final List<OFBucketCounter> bucketStats;
    static final OFGroupStatsEntryVer11 DEFAULT = new OFGroupStatsEntryVer11(DEFAULT_GROUP_ID, 0L, DEFAULT_PACKET_COUNT, DEFAULT_BYTE_COUNT, DEFAULT_BUCKET_STATS);
    static final Reader READER = new Reader();
    static final OFGroupStatsEntryVer11Funnel FUNNEL = new OFGroupStatsEntryVer11Funnel();
    static final Writer WRITER = new Writer();

    OFGroupStatsEntryVer11(OFGroup group, long refCount, U64 packetCount, U64 byteCount, List<OFBucketCounter> bucketStats) {
        if (group == null) {
            throw new NullPointerException("OFGroupStatsEntryVer11: property group cannot be null");
        }
        if (packetCount == null) {
            throw new NullPointerException("OFGroupStatsEntryVer11: property packetCount cannot be null");
        }
        if (byteCount == null) {
            throw new NullPointerException("OFGroupStatsEntryVer11: property byteCount cannot be null");
        }
        if (bucketStats == null) {
            throw new NullPointerException("OFGroupStatsEntryVer11: property bucketStats cannot be null");
        }
        this.group = group;
        this.refCount = U32.normalize(refCount);
        this.packetCount = packetCount;
        this.byteCount = byteCount;
        this.bucketStats = bucketStats;
    }

    @Override
    public OFGroup getGroup() {
        return this.group;
    }

    @Override
    public long getRefCount() {
        return this.refCount;
    }

    @Override
    public U64 getPacketCount() {
        return this.packetCount;
    }

    @Override
    public U64 getByteCount() {
        return this.byteCount;
    }

    @Override
    public List<OFBucketCounter> getBucketStats() {
        return this.bucketStats;
    }

    @Override
    public long getDurationSec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
    }

    @Override
    public long getDurationNsec() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFGroupStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupStatsEntryVer11(");
        b.append("group=").append(this.group);
        b.append(", ");
        b.append("refCount=").append(this.refCount);
        b.append(", ");
        b.append("packetCount=").append(this.packetCount);
        b.append(", ");
        b.append("byteCount=").append(this.byteCount);
        b.append(", ");
        b.append("bucketStats=").append(this.bucketStats);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupStatsEntryVer11 other = (OFGroupStatsEntryVer11)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.refCount != other.refCount) {
            return false;
        }
        if (this.packetCount == null ? other.packetCount != null : !this.packetCount.equals(other.packetCount)) {
            return false;
        }
        if (this.byteCount == null ? other.byteCount != null : !this.byteCount.equals(other.byteCount)) {
            return false;
        }
        return !(this.bucketStats == null ? other.bucketStats != null : !this.bucketStats.equals(other.bucketStats));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * (int)(this.refCount ^ this.refCount >>> 32);
        result = 31 * result + (this.packetCount == null ? 0 : this.packetCount.hashCode());
        result = 31 * result + (this.byteCount == null ? 0 : this.byteCount.hashCode());
        result = 31 * result + (this.bucketStats == null ? 0 : this.bucketStats.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupStatsEntryVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupStatsEntryVer11 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.group.write4Bytes(bb);
            bb.writeInt(U32.t(message.refCount));
            bb.writeZero(4);
            bb.writeLong(message.packetCount.getValue());
            bb.writeLong(message.byteCount.getValue());
            ChannelUtils.writeList(bb, message.bucketStats);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFGroupStatsEntryVer11: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFGroupStatsEntryVer11Funnel
    implements Funnel<OFGroupStatsEntryVer11> {
        private static final long serialVersionUID = 1L;

        OFGroupStatsEntryVer11Funnel() {
        }

        public void funnel(OFGroupStatsEntryVer11 message, PrimitiveSink sink) {
            message.group.putTo(sink);
            sink.putLong(message.refCount);
            message.packetCount.putTo(sink);
            message.byteCount.putTo(sink);
            FunnelUtils.putList(message.bucketStats, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupStatsEntry> {
        Reader() {
        }

        @Override
        public OFGroupStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 32) {
                throw new OFParseError("Wrong length: Expected to be >= 32, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            OFGroup group = OFGroup.read4Bytes(bb);
            long refCount = U32.f(bb.readInt());
            bb.skipBytes(4);
            U64 packetCount = U64.ofRaw(bb.readLong());
            U64 byteCount = U64.ofRaw(bb.readLong());
            List<OFBucketCounter> bucketStats = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBucketCounterVer11.READER);
            OFGroupStatsEntryVer11 groupStatsEntryVer11 = new OFGroupStatsEntryVer11(group, refCount, packetCount, byteCount, bucketStats);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupStatsEntryVer11);
            }
            return groupStatsEntryVer11;
        }
    }

    static class Builder
    implements OFGroupStatsEntry.Builder {
        private boolean groupSet;
        private OFGroup group;
        private boolean refCountSet;
        private long refCount;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean bucketStatsSet;
        private List<OFBucketCounter> bucketStats;

        Builder() {
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public long getRefCount() {
            return this.refCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setRefCount(long refCount) {
            this.refCount = refCount;
            this.refCountSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public List<OFBucketCounter> getBucketStats() {
            return this.bucketStats;
        }

        @Override
        public OFGroupStatsEntry.Builder setBucketStats(List<OFBucketCounter> bucketStats) {
            this.bucketStats = bucketStats;
            this.bucketStatsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFGroupStatsEntry build() {
            List<OFBucketCounter> bucketStats;
            U64 byteCount;
            U64 packetCount;
            OFGroup group;
            OFGroup oFGroup = group = this.groupSet ? this.group : DEFAULT_GROUP_ID;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            long refCount = this.refCountSet ? this.refCount : 0L;
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : DEFAULT_PACKET_COUNT;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : DEFAULT_BYTE_COUNT;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            List<OFBucketCounter> list = bucketStats = this.bucketStatsSet ? this.bucketStats : DEFAULT_BUCKET_STATS;
            if (bucketStats == null) {
                throw new NullPointerException("Property bucketStats must not be null");
            }
            return new OFGroupStatsEntryVer11(group, refCount, packetCount, byteCount, bucketStats);
        }
    }

    static class BuilderWithParent
    implements OFGroupStatsEntry.Builder {
        final OFGroupStatsEntryVer11 parentMessage;
        private boolean groupSet;
        private OFGroup group;
        private boolean refCountSet;
        private long refCount;
        private boolean packetCountSet;
        private U64 packetCount;
        private boolean byteCountSet;
        private U64 byteCount;
        private boolean bucketStatsSet;
        private List<OFBucketCounter> bucketStats;

        BuilderWithParent(OFGroupStatsEntryVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFGroup getGroup() {
            return this.group;
        }

        @Override
        public OFGroupStatsEntry.Builder setGroup(OFGroup group) {
            this.group = group;
            this.groupSet = true;
            return this;
        }

        @Override
        public long getRefCount() {
            return this.refCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setRefCount(long refCount) {
            this.refCount = refCount;
            this.refCountSet = true;
            return this;
        }

        @Override
        public U64 getPacketCount() {
            return this.packetCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setPacketCount(U64 packetCount) {
            this.packetCount = packetCount;
            this.packetCountSet = true;
            return this;
        }

        @Override
        public U64 getByteCount() {
            return this.byteCount;
        }

        @Override
        public OFGroupStatsEntry.Builder setByteCount(U64 byteCount) {
            this.byteCount = byteCount;
            this.byteCountSet = true;
            return this;
        }

        @Override
        public List<OFBucketCounter> getBucketStats() {
            return this.bucketStats;
        }

        @Override
        public OFGroupStatsEntry.Builder setBucketStats(List<OFBucketCounter> bucketStats) {
            this.bucketStats = bucketStats;
            this.bucketStatsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.1");
        }

        @Override
        public long getDurationNsec() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFGroupStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.1");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFGroupStatsEntry build() {
            List bucketStats;
            U64 byteCount;
            U64 packetCount;
            OFGroup group;
            OFGroup oFGroup = group = this.groupSet ? this.group : this.parentMessage.group;
            if (group == null) {
                throw new NullPointerException("Property group must not be null");
            }
            long refCount = this.refCountSet ? this.refCount : this.parentMessage.refCount;
            U64 u64 = packetCount = this.packetCountSet ? this.packetCount : this.parentMessage.packetCount;
            if (packetCount == null) {
                throw new NullPointerException("Property packetCount must not be null");
            }
            U64 u642 = byteCount = this.byteCountSet ? this.byteCount : this.parentMessage.byteCount;
            if (byteCount == null) {
                throw new NullPointerException("Property byteCount must not be null");
            }
            List list = bucketStats = this.bucketStatsSet ? this.bucketStats : this.parentMessage.bucketStats;
            if (bucketStats == null) {
                throw new NullPointerException("Property bucketStats must not be null");
            }
            return new OFGroupStatsEntryVer11(group, refCount, packetCount, byteCount, bucketStats);
        }
    }
}

