/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver10.OFStatsRequestFlagsSerializerVer10;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsRequestVer10
implements OFPortStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsRequestVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 20;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final OFPort portNo;
    static final OFPortStatsRequestVer10 DEFAULT = new OFPortStatsRequestVer10(0L, DEFAULT_FLAGS, DEFAULT_PORT_NO);
    static final Reader READER = new Reader();
    static final OFPortStatsRequestVer10Funnel FUNNEL = new OFPortStatsRequestVer10Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsRequestVer10(long xid, Set<OFStatsRequestFlags> flags, OFPort portNo) {
        if (flags == null) {
            throw new NullPointerException("OFPortStatsRequestVer10: property flags cannot be null");
        }
        if (portNo == null) {
            throw new NullPointerException("OFPortStatsRequestVer10: property portNo cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.portNo = portNo;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.PORT;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public OFPortStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsRequestVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsRequestVer10 other = (OFPortStatsRequestVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsRequestVer10 other = (OFPortStatsRequestVer10)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsRequestVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortStatsRequestVer10 message) {
            bb.writeByte(1);
            bb.writeByte(16);
            bb.writeShort(20);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(4);
            OFStatsRequestFlagsSerializerVer10.writeTo(bb, message.flags);
            message.portNo.write2Bytes(bb);
            bb.writeZero(6);
        }
    }

    static class OFPortStatsRequestVer10Funnel
    implements Funnel<OFPortStatsRequestVer10> {
        private static final long serialVersionUID = 1L;

        OFPortStatsRequestVer10Funnel() {
        }

        public void funnel(OFPortStatsRequestVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)16);
            sink.putShort((short)20);
            sink.putLong(message.xid);
            sink.putShort((short)4);
            OFStatsRequestFlagsSerializerVer10.putTo(message.flags, sink);
            message.portNo.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsRequest> {
        Reader() {
        }

        @Override
        public OFPortStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 4) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.PORT(4), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer10.readFrom(bb);
            OFPort portNo = OFPort.read2Bytes(bb);
            bb.skipBytes(6);
            OFPortStatsRequestVer10 portStatsRequestVer10 = new OFPortStatsRequestVer10(xid, flags, portNo);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsRequestVer10);
            }
            return portStatsRequestVer10;
        }
    }

    static class Builder
    implements OFPortStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFPortStatsRequest build() {
            OFPort portNo;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFPortStatsRequestVer10(xid, flags, portNo);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsRequest.Builder {
        final OFPortStatsRequestVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;

        BuilderWithParent(OFPortStatsRequestVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsRequest.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFPortStatsRequest build() {
            OFPort portNo;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFPortStatsRequestVer10(xid, flags, portNo);
        }
    }
}

