/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver10.OFBarrierReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFBarrierRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFEchoReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFEchoRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFErrorMsgVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFExperimenterVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFeaturesReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFeaturesRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowModVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowRemovedVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFGetConfigReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFGetConfigRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFHelloVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPacketInVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPacketOutVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortModVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortStatusVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFQueueGetConfigReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFQueueGetConfigRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFSetConfigVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFStatsReplyVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFStatsRequestVer10;

abstract class OFMessageVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFMessageVer10() {
    }

    static class Reader
    implements OFMessageReader<OFMessage> {
        Reader() {
        }

        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch (type) {
                case 17: {
                    return OFStatsReplyVer10.READER.readFrom(bb);
                }
                case 16: {
                    return OFStatsRequestVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFErrorMsgVer10.READER.readFrom(bb);
                }
                case 19: {
                    return OFBarrierReplyVer10.READER.readFrom(bb);
                }
                case 18: {
                    return OFBarrierRequestVer10.READER.readFrom(bb);
                }
                case 4: {
                    return OFExperimenterVer10.READER.readFrom(bb);
                }
                case 3: {
                    return OFEchoReplyVer10.READER.readFrom(bb);
                }
                case 2: {
                    return OFEchoRequestVer10.READER.readFrom(bb);
                }
                case 6: {
                    return OFFeaturesReplyVer10.READER.readFrom(bb);
                }
                case 5: {
                    return OFFeaturesRequestVer10.READER.readFrom(bb);
                }
                case 14: {
                    return OFFlowModVer10.READER.readFrom(bb);
                }
                case 11: {
                    return OFFlowRemovedVer10.READER.readFrom(bb);
                }
                case 8: {
                    return OFGetConfigReplyVer10.READER.readFrom(bb);
                }
                case 7: {
                    return OFGetConfigRequestVer10.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloVer10.READER.readFrom(bb);
                }
                case 10: {
                    return OFPacketInVer10.READER.readFrom(bb);
                }
                case 13: {
                    return OFPacketOutVer10.READER.readFrom(bb);
                }
                case 15: {
                    return OFPortModVer10.READER.readFrom(bb);
                }
                case 12: {
                    return OFPortStatusVer10.READER.readFrom(bb);
                }
                case 21: {
                    return OFQueueGetConfigReplyVer10.READER.readFrom(bb);
                }
                case 20: {
                    return OFQueueGetConfigRequestVer10.READER.readFrom(bb);
                }
                case 9: {
                    return OFSetConfigVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFMessageVer10: " + type);
        }
    }
}

