/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnShellCommand;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnShellCommandVer10
implements OFBsnShellCommand {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnShellCommandVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 20;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_SERVICE = 0L;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final long service;
    private final byte[] data;
    static final OFBsnShellCommandVer10 DEFAULT = new OFBsnShellCommandVer10(0L, 0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnShellCommandVer10Funnel FUNNEL = new OFBsnShellCommandVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnShellCommandVer10(long xid, long service, byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFBsnShellCommandVer10: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.service = U32.normalize(service);
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 6L;
    }

    @Override
    public long getService() {
        return this.service;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFBsnShellCommand.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnShellCommandVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("service=").append(this.service);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnShellCommandVer10 other = (OFBsnShellCommandVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.service != other.service) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnShellCommandVer10 other = (OFBsnShellCommandVer10)obj;
        if (this.service != other.service) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.service ^ this.service >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.service ^ this.service >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnShellCommandVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnShellCommandVer10 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(1);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(6);
            bb.writeInt(U32.t(message.service));
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnShellCommandVer10: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnShellCommandVer10Funnel
    implements Funnel<OFBsnShellCommandVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnShellCommandVer10Funnel() {
        }

        public void funnel(OFBsnShellCommandVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(6);
            sink.putLong(message.service);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnShellCommand> {
        Reader() {
        }

        @Override
        public OFBsnShellCommand readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 20) {
                throw new OFParseError("Wrong length: Expected to be >= 20, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 6) {
                throw new OFParseError("Wrong subtype: Expected=0x6L(0x6L), got=" + subtype);
            }
            long service = U32.f(bb.readInt());
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnShellCommandVer10 bsnShellCommandVer10 = new OFBsnShellCommandVer10(xid, service, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnShellCommandVer10);
            }
            return bsnShellCommandVer10;
        }
    }

    static class Builder
    implements OFBsnShellCommand.Builder {
        private boolean xidSet;
        private long xid;
        private boolean serviceSet;
        private long service;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnShellCommand.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 6L;
        }

        @Override
        public long getService() {
            return this.service;
        }

        @Override
        public OFBsnShellCommand.Builder setService(long service) {
            this.service = service;
            this.serviceSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnShellCommand.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnShellCommand build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : 0L;
            long service = this.serviceSet ? this.service : 0L;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnShellCommandVer10(xid, service, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnShellCommand.Builder {
        final OFBsnShellCommandVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean serviceSet;
        private long service;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFBsnShellCommandVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnShellCommand.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 6L;
        }

        @Override
        public long getService() {
            return this.service;
        }

        @Override
        public OFBsnShellCommand.Builder setService(long service) {
            this.service = service;
            this.serviceSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnShellCommand.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnShellCommand build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long service = this.serviceSet ? this.service : this.parentMessage.service;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnShellCommandVer10(xid, service, data);
        }
    }
}

