/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGetIpMaskReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGetIpMaskReplyVer10
implements OFBsnGetIpMaskReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGetIpMaskReplyVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final short DEFAULT_INDEX = 0;
    private static final long DEFAULT_MASK = 0L;
    private final long xid;
    private final short index;
    private final long mask;
    static final OFBsnGetIpMaskReplyVer10 DEFAULT = new OFBsnGetIpMaskReplyVer10(0L, 0, 0L);
    static final Reader READER = new Reader();
    static final OFBsnGetIpMaskReplyVer10Funnel FUNNEL = new OFBsnGetIpMaskReplyVer10Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGetIpMaskReplyVer10(long xid, short index, long mask) {
        this.xid = U32.normalize(xid);
        this.index = U8.normalize(index);
        this.mask = U32.normalize(mask);
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 2L;
    }

    @Override
    public short getIndex() {
        return this.index;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFBsnGetIpMaskReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGetIpMaskReplyVer10(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("index=").append(this.index);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetIpMaskReplyVer10 other = (OFBsnGetIpMaskReplyVer10)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return this.mask == other.mask;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGetIpMaskReplyVer10 other = (OFBsnGetIpMaskReplyVer10)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + this.index;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGetIpMaskReplyVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGetIpMaskReplyVer10 message) {
            bb.writeByte(1);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(2);
            bb.writeByte((int)U8.t(message.index));
            bb.writeZero(3);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFBsnGetIpMaskReplyVer10Funnel
    implements Funnel<OFBsnGetIpMaskReplyVer10> {
        private static final long serialVersionUID = 1L;

        OFBsnGetIpMaskReplyVer10Funnel() {
        }

        public void funnel(OFBsnGetIpMaskReplyVer10 message, PrimitiveSink sink) {
            sink.putByte((byte)1);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(2);
            sink.putShort(message.index);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGetIpMaskReply> {
        Reader() {
        }

        @Override
        public OFBsnGetIpMaskReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2L(0x2L), got=" + subtype);
            }
            short index = U8.f(bb.readByte());
            bb.skipBytes(3);
            long mask = U32.f(bb.readInt());
            OFBsnGetIpMaskReplyVer10 bsnGetIpMaskReplyVer10 = new OFBsnGetIpMaskReplyVer10(xid, index, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGetIpMaskReplyVer10);
            }
            return bsnGetIpMaskReplyVer10;
        }
    }

    static class Builder
    implements OFBsnGetIpMaskReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean indexSet;
        private short index;
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetIpMaskReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public short getIndex() {
            return this.index;
        }

        @Override
        public OFBsnGetIpMaskReply.Builder setIndex(short index) {
            this.index = index;
            this.indexSet = true;
            return this;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFBsnGetIpMaskReply.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFBsnGetIpMaskReply build() {
            long xid = this.xidSet ? this.xid : 0L;
            short index = this.indexSet ? this.index : (short)0;
            long mask = this.maskSet ? this.mask : 0L;
            return new OFBsnGetIpMaskReplyVer10(xid, index, mask);
        }
    }

    static class BuilderWithParent
    implements OFBsnGetIpMaskReply.Builder {
        final OFBsnGetIpMaskReplyVer10 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean indexSet;
        private short index;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFBsnGetIpMaskReplyVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGetIpMaskReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public short getIndex() {
            return this.index;
        }

        @Override
        public OFBsnGetIpMaskReply.Builder setIndex(short index) {
            this.index = index;
            this.indexSet = true;
            return this;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFBsnGetIpMaskReply.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFBsnGetIpMaskReply build() {
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            short index = this.indexSet ? this.index : this.parentMessage.index;
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFBsnGetIpMaskReplyVer10(xid, index, mask);
        }
    }
}

