/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetVlanVid;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.VlanVid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetVlanVidVer10
implements OFActionSetVlanVid {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetVlanVidVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 8;
    private static final VlanVid DEFAULT_VLAN_VID = VlanVid.ZERO;
    private final VlanVid vlanVid;
    static final OFActionSetVlanVidVer10 DEFAULT = new OFActionSetVlanVidVer10(DEFAULT_VLAN_VID);
    static final Reader READER = new Reader();
    static final OFActionSetVlanVidVer10Funnel FUNNEL = new OFActionSetVlanVidVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetVlanVidVer10(VlanVid vlanVid) {
        if (vlanVid == null) {
            throw new NullPointerException("OFActionSetVlanVidVer10: property vlanVid cannot be null");
        }
        this.vlanVid = vlanVid;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_VLAN_VID;
    }

    @Override
    public VlanVid getVlanVid() {
        return this.vlanVid;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionSetVlanVid.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetVlanVidVer10(");
        b.append("vlanVid=").append(this.vlanVid);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetVlanVidVer10 other = (OFActionSetVlanVidVer10)obj;
        return !(this.vlanVid == null ? other.vlanVid != null : !this.vlanVid.equals(other.vlanVid));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vlanVid == null ? 0 : this.vlanVid.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetVlanVidVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetVlanVidVer10 message) {
            bb.writeShort(1);
            bb.writeShort(8);
            message.vlanVid.write2Bytes(bb);
            bb.writeZero(2);
        }
    }

    static class OFActionSetVlanVidVer10Funnel
    implements Funnel<OFActionSetVlanVidVer10> {
        private static final long serialVersionUID = 1L;

        OFActionSetVlanVidVer10Funnel() {
        }

        public void funnel(OFActionSetVlanVidVer10 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)8);
            message.vlanVid.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetVlanVid> {
        Reader() {
        }

        @Override
        public OFActionSetVlanVid readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_VLAN_VID(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            VlanVid vlanVid = VlanVid.read2Bytes(bb);
            bb.skipBytes(2);
            OFActionSetVlanVidVer10 actionSetVlanVidVer10 = new OFActionSetVlanVidVer10(vlanVid);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetVlanVidVer10);
            }
            return actionSetVlanVidVer10;
        }
    }

    static class Builder
    implements OFActionSetVlanVid.Builder {
        private boolean vlanVidSet;
        private VlanVid vlanVid;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_VLAN_VID;
        }

        @Override
        public VlanVid getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFActionSetVlanVid.Builder setVlanVid(VlanVid vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetVlanVid build() {
            VlanVid vlanVid;
            VlanVid vlanVid2 = vlanVid = this.vlanVidSet ? this.vlanVid : DEFAULT_VLAN_VID;
            if (vlanVid == null) {
                throw new NullPointerException("Property vlanVid must not be null");
            }
            return new OFActionSetVlanVidVer10(vlanVid);
        }
    }

    static class BuilderWithParent
    implements OFActionSetVlanVid.Builder {
        final OFActionSetVlanVidVer10 parentMessage;
        private boolean vlanVidSet;
        private VlanVid vlanVid;

        BuilderWithParent(OFActionSetVlanVidVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_VLAN_VID;
        }

        @Override
        public VlanVid getVlanVid() {
            return this.vlanVid;
        }

        @Override
        public OFActionSetVlanVid.Builder setVlanVid(VlanVid vlanVid) {
            this.vlanVid = vlanVid;
            this.vlanVidSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetVlanVid build() {
            VlanVid vlanVid;
            VlanVid vlanVid2 = vlanVid = this.vlanVidSet ? this.vlanVid : this.parentMessage.vlanVid;
            if (vlanVid == null) {
                throw new NullPointerException("Property vlanVid must not be null");
            }
            return new OFActionSetVlanVidVer10(vlanVid);
        }
    }
}

