/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.match;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.types.OFValueType;

public class Prerequisite<T extends OFValueType<T>> {
    private final MatchField<T> field;
    private final Set<OFValueType<T>> values;
    private final boolean any;

    @SafeVarargs
    public Prerequisite(MatchField<T> field, OFValueType<T> ... values) {
        this.field = field;
        if (values == null || values.length == 0) {
            this.any = true;
            this.values = ImmutableSet.of();
        } else {
            this.any = false;
            this.values = ImmutableSet.copyOf((Object[])values);
        }
    }

    public boolean isSatisfied(Match match) {
        T res = match.get(this.field);
        if (res == null) {
            return false;
        }
        if (this.any) {
            return true;
        }
        return this.values.contains(res);
    }

    public Set<OFValueType<T>> getValues() {
        return this.values;
    }

    public MatchField<T> getMatchField() {
        return this.field;
    }
}

