/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver11.OFFactoryVer11;
import org.projectfloodlight.openflow.protocol.ver12.OFFactoryVer12;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver14.OFFactoryVer14;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.types.U8;

public final class OFFactories {
    private static final GenericReader GENERIC_READER = new GenericReader();

    public static OFFactory getFactory(OFVersion version) {
        switch (version) {
            case OF_10: {
                return OFFactoryVer10.INSTANCE;
            }
            case OF_11: {
                return OFFactoryVer11.INSTANCE;
            }
            case OF_12: {
                return OFFactoryVer12.INSTANCE;
            }
            case OF_13: {
                return OFFactoryVer13.INSTANCE;
            }
            case OF_14: {
                return OFFactoryVer14.INSTANCE;
            }
            case OF_15: {
                return OFFactoryVer15.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unknown version: " + (Object)((Object)version));
    }

    public static OFMessageReader<OFMessage> getGenericReader() {
        return GENERIC_READER;
    }

    private static class GenericReader
    implements OFMessageReader<OFMessage> {
        private GenericReader() {
        }

        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            OFFactory factory;
            if (!bb.isReadable()) {
                return null;
            }
            short wireVersion = U8.f(bb.getByte(bb.readerIndex()));
            switch (wireVersion) {
                case 1: {
                    factory = OFFactoryVer10.INSTANCE;
                    break;
                }
                case 2: {
                    factory = OFFactoryVer11.INSTANCE;
                    break;
                }
                case 3: {
                    factory = OFFactoryVer12.INSTANCE;
                    break;
                }
                case 4: {
                    factory = OFFactoryVer13.INSTANCE;
                    break;
                }
                case 5: {
                    factory = OFFactoryVer14.INSTANCE;
                    break;
                }
                case 6: {
                    factory = OFFactoryVer15.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown wire version: " + wireVersion);
                }
            }
            return factory.getReader().readFrom(bb);
        }
    }
}

