/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.protocol;

import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.OFVersion;

public class OFMessageTest {
    private OFFactory factory;

    @Before
    public void setup() {
        this.factory = OFFactories.getFactory((OFVersion)OFVersion.OF_14);
    }

    @Test
    public void messageTooLong() {
        byte[] tooLong = new byte[65512];
        OFPacketOut packetOut = this.factory.buildPacketOut().setData(tooLong).build();
        try {
            packetOut.writeTo(Unpooled.buffer());
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)" message length (65536) exceeds maximum (0xFFFF)"));
        }
    }
}

