/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPacketInReason;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPacketInVer13;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFPacketInVer13Test {
    OFFactory factory;
    static final byte[] PACKET_IN_SERIALIZED = new byte[]{4, 10, 0, 53, 18, 52, 86, 120, 0, 0, 0, 100, 66, 104, 1, 20, -2, -36, -70, -104, 118, 84, 50, 16, 0, 1, 0, 22, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, -128, 0, 42, 2, 0, 1, 0, 0, 0, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPacketIn.Builder builder = this.factory.buildPacketIn();
        builder.setXid(305419896L).setBufferId(OFBufferId.of((int)100)).setTotalLen(17000).setReason(OFPacketInReason.ACTION).setTableId(TableId.of((int)20)).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setMatch(this.factory.buildMatchV3().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.REQUEST).build()).setData(new byte[]{97, 98, 99});
        OFPacketIn packetIn = builder.build();
        ByteBuf bb = Unpooled.buffer();
        packetIn.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_IN_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPacketIn.Builder builder = this.factory.buildPacketIn();
        builder.setXid(305419896L).setBufferId(OFBufferId.of((int)100)).setTotalLen(17000).setReason(OFPacketInReason.ACTION).setTableId(TableId.of((int)20)).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setMatch(this.factory.buildMatchV3().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.REQUEST).build()).setData(new byte[]{97, 98, 99});
        OFPacketIn packetInBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PACKET_IN_SERIALIZED);
        OFPacketIn packetInRead = OFPacketInVer13.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_IN_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)packetInBuilt, (Object)packetInRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PACKET_IN_SERIALIZED);
        OFPacketIn packetIn = OFPacketInVer13.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_IN_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        packetIn.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_IN_SERIALIZED));
    }
}

