/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableEntryStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U64;

public class OFBsnGentableEntryStatsReplyVer13Test {
    OFFactory factory;
    static final byte[] BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED = new byte[]{4, 19, 0, 96, 18, 52, 86, 120, -1, -1, 0, 0, 0, 0, 0, 0, 0, 92, 22, -57, 0, 0, 0, 3, 0, 36, 0, 8, 0, 0, 0, 8, 0, 0, 0, 5, 0, 2, 0, 12, 0, 0, 0, 0, 0, 0, 0, 100, 0, 3, 0, 12, 0, 0, 0, 0, 0, 0, 0, 101, 0, 36, 0, 8, 0, 0, 0, 8, 0, 0, 0, 6, 0, 2, 0, 12, 0, 0, 0, 0, 0, 0, 0, 100, 0, 3, 0, 12, 0, 0, 0, 0, 0, 0, 0, 101};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnGentableEntryStatsReply.Builder builder = this.factory.buildBsnGentableEntryStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.bsnGentableEntryStatsEntry((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)5))), (List)ImmutableList.of((Object)this.factory.bsnTlvs().rxPackets(U64.of((long)100L)), (Object)this.factory.bsnTlvs().txPackets(U64.of((long)101L)))), (Object)this.factory.bsnGentableEntryStatsEntry((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)6))), (List)ImmutableList.of((Object)this.factory.bsnTlvs().rxPackets(U64.of((long)100L)), (Object)this.factory.bsnTlvs().txPackets(U64.of((long)101L))))));
        OFBsnGentableEntryStatsReply bsnGentableEntryStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bsnGentableEntryStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnGentableEntryStatsReply.Builder builder = this.factory.buildBsnGentableEntryStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.bsnGentableEntryStatsEntry((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)5))), (List)ImmutableList.of((Object)this.factory.bsnTlvs().rxPackets(U64.of((long)100L)), (Object)this.factory.bsnTlvs().txPackets(U64.of((long)101L)))), (Object)this.factory.bsnGentableEntryStatsEntry((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)6))), (List)ImmutableList.of((Object)this.factory.bsnTlvs().rxPackets(U64.of((long)100L)), (Object)this.factory.bsnTlvs().txPackets(U64.of((long)101L))))));
        OFBsnGentableEntryStatsReply bsnGentableEntryStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED);
        OFBsnGentableEntryStatsReply bsnGentableEntryStatsReplyRead = OFBsnGentableEntryStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnGentableEntryStatsReplyBuilt, (Object)bsnGentableEntryStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED);
        OFBsnGentableEntryStatsReply bsnGentableEntryStatsReply = OFBsnGentableEntryStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bsnGentableEntryStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_ENTRY_STATS_REPLY_SERIALIZED));
    }
}

