// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFFlowRemovedVer15 implements OFFlowRemoved {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowRemovedVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 40;
    // maximum OF message length: 16 bit, unsigned
    final static int MAXIMUM_LENGTH = 0xFFFF;

        private final static long DEFAULT_XID = 0x0L;
        private final static TableId DEFAULT_TABLE_ID = TableId.ALL;
        private final static int DEFAULT_PRIORITY = 0x0;
        private final static int DEFAULT_IDLE_TIMEOUT = 0x0;
        private final static int DEFAULT_HARD_TIMEOUT = 0x0;
        private final static U64 DEFAULT_COOKIE = U64.ZERO;
        private final static Match DEFAULT_MATCH = OFFactoryVer15.MATCH_WILDCARD_ALL;

    // OF message fields
    private final long xid;
    private final TableId tableId;
    private final OFFlowRemovedReason reason;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final U64 cookie;
    private final Match match;
    private final Stat stats;
//

    // package private constructor - used by readers, builders, and factory
    OFFlowRemovedVer15(long xid, TableId tableId, OFFlowRemovedReason reason, int priority, int idleTimeout, int hardTimeout, U64 cookie, Match match, Stat stats) {
        if(tableId == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property tableId cannot be null");
        }
        if(reason == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property reason cannot be null");
        }
        if(cookie == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property cookie cannot be null");
        }
        if(match == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property match cannot be null");
        }
        if(stats == null) {
            throw new NullPointerException("OFFlowRemovedVer15: property stats cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.tableId = tableId;
        this.reason = reason;
        this.priority = U16.normalize(priority);
        this.idleTimeout = U16.normalize(idleTimeout);
        this.hardTimeout = U16.normalize(hardTimeout);
        this.cookie = cookie;
        this.match = match;
        this.stats = stats;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_REMOVED;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFFlowRemovedReason getReason() {
        return reason;
    }

    @Override
    public long getDurationSec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public long getDurationNsec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public U64 getPacketCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public U64 getByteCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public Stat getStats() {
        return stats;
    }



    public OFFlowRemoved.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFFlowRemoved.Builder {
        final OFFlowRemovedVer15 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean reasonSet;
        private OFFlowRemovedReason reason;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;

        BuilderWithParent(OFFlowRemovedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_REMOVED;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFFlowRemoved.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public OFFlowRemoved.Builder setMatch(Match match) {
        this.match = match;
        this.matchSet = true;
        return this;
    }
    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public OFFlowRemoved.Builder setCookie(U64 cookie) {
        this.cookie = cookie;
        this.cookieSet = true;
        return this;
    }
    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFFlowRemoved.Builder setPriority(int priority) {
        this.priority = priority;
        this.prioritySet = true;
        return this;
    }
    @Override
    public OFFlowRemovedReason getReason() {
        return reason;
    }

    @Override
    public OFFlowRemoved.Builder setReason(OFFlowRemovedReason reason) {
        this.reason = reason;
        this.reasonSet = true;
        return this;
    }
    @Override
    public long getDurationSec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }
    @Override
    public long getDurationNsec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }
    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.idleTimeoutSet = true;
        return this;
    }
    @Override
    public U64 getPacketCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }
    @Override
    public U64 getByteCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }
    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFFlowRemoved.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) {
        this.hardTimeout = hardTimeout;
        this.hardTimeoutSet = true;
        return this;
    }
    @Override
    public Stat getStats() {
        return stats;
    }

    @Override
    public OFFlowRemoved.Builder setStats(Stat stats) {
        this.stats = stats;
        this.statsSet = true;
        return this;
    }


        @Override
        public OFFlowRemoved build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                TableId tableId = this.tableIdSet ? this.tableId : parentMessage.tableId;
                if(tableId == null)
                    throw new NullPointerException("Property tableId must not be null");
                OFFlowRemovedReason reason = this.reasonSet ? this.reason : parentMessage.reason;
                if(reason == null)
                    throw new NullPointerException("Property reason must not be null");
                int priority = this.prioritySet ? this.priority : parentMessage.priority;
                int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : parentMessage.idleTimeout;
                int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : parentMessage.hardTimeout;
                U64 cookie = this.cookieSet ? this.cookie : parentMessage.cookie;
                if(cookie == null)
                    throw new NullPointerException("Property cookie must not be null");
                Match match = this.matchSet ? this.match : parentMessage.match;
                if(match == null)
                    throw new NullPointerException("Property match must not be null");
                Stat stats = this.statsSet ? this.stats : parentMessage.stats;
                if(stats == null)
                    throw new NullPointerException("Property stats must not be null");

                //
                return new OFFlowRemovedVer15(
                    xid,
                    tableId,
                    reason,
                    priority,
                    idleTimeout,
                    hardTimeout,
                    cookie,
                    match,
                    stats
                );
        }

    }

    static class Builder implements OFFlowRemoved.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean reasonSet;
        private OFFlowRemovedReason reason;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.FLOW_REMOVED;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFFlowRemoved.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public OFFlowRemoved.Builder setMatch(Match match) {
        this.match = match;
        this.matchSet = true;
        return this;
    }
    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public OFFlowRemoved.Builder setCookie(U64 cookie) {
        this.cookie = cookie;
        this.cookieSet = true;
        return this;
    }
    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFFlowRemoved.Builder setPriority(int priority) {
        this.priority = priority;
        this.prioritySet = true;
        return this;
    }
    @Override
    public OFFlowRemovedReason getReason() {
        return reason;
    }

    @Override
    public OFFlowRemoved.Builder setReason(OFFlowRemovedReason reason) {
        this.reason = reason;
        this.reasonSet = true;
        return this;
    }
    @Override
    public long getDurationSec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }
    @Override
    public long getDurationNsec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }
    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public OFFlowRemoved.Builder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.idleTimeoutSet = true;
        return this;
    }
    @Override
    public U64 getPacketCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }
    @Override
    public U64 getByteCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public OFFlowRemoved.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }
    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFFlowRemoved.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public OFFlowRemoved.Builder setHardTimeout(int hardTimeout) {
        this.hardTimeout = hardTimeout;
        this.hardTimeoutSet = true;
        return this;
    }
    @Override
    public Stat getStats() {
        return stats;
    }

    @Override
    public OFFlowRemoved.Builder setStats(Stat stats) {
        this.stats = stats;
        this.statsSet = true;
        return this;
    }
//
        @Override
        public OFFlowRemoved build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            TableId tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if(tableId == null)
                throw new NullPointerException("Property tableId must not be null");
            if(!this.reasonSet)
                throw new IllegalStateException("Property reason doesn't have default value -- must be set");
            if(reason == null)
                throw new NullPointerException("Property reason must not be null");
            int priority = this.prioritySet ? this.priority : DEFAULT_PRIORITY;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : DEFAULT_IDLE_TIMEOUT;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : DEFAULT_HARD_TIMEOUT;
            U64 cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if(cookie == null)
                throw new NullPointerException("Property cookie must not be null");
            Match match = this.matchSet ? this.match : DEFAULT_MATCH;
            if(match == null)
                throw new NullPointerException("Property match must not be null");
            if(!this.statsSet)
                throw new IllegalStateException("Property stats doesn't have default value -- must be set");
            if(stats == null)
                throw new NullPointerException("Property stats must not be null");


            return new OFFlowRemovedVer15(
                    xid,
                    tableId,
                    reason,
                    priority,
                    idleTimeout,
                    hardTimeout,
                    cookie,
                    match,
                    stats
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFFlowRemoved> {
        @Override
        public OFFlowRemoved readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 6
            byte version = bb.readByte();
            if(version != (byte) 0x6)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got="+version);
            // fixed value property type == 11
            byte type = bb.readByte();
            if(type != (byte) 0xb)
                throw new OFParseError("Wrong type: Expected=OFType.FLOW_REMOVED(11), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            TableId tableId = TableId.readByte(bb);
            OFFlowRemovedReason reason = OFFlowRemovedReasonSerializerVer15.readFrom(bb);
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            U64 cookie = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer15.readOFMatch(bb);
            Stat stats = ChannelUtilsVer15.readOFStat(bb);

            OFFlowRemovedVer15 flowRemovedVer15 = new OFFlowRemovedVer15(
                    xid,
                      tableId,
                      reason,
                      priority,
                      idleTimeout,
                      hardTimeout,
                      cookie,
                      match,
                      stats
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", flowRemovedVer15);
            return flowRemovedVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFFlowRemovedVer15Funnel FUNNEL = new OFFlowRemovedVer15Funnel();
    static class OFFlowRemovedVer15Funnel implements Funnel<OFFlowRemovedVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFFlowRemovedVer15 message, PrimitiveSink sink) {
            // fixed value property version = 6
            sink.putByte((byte) 0x6);
            // fixed value property type = 11
            sink.putByte((byte) 0xb);
            // FIXME: skip funnel of length
            sink.putLong(message.xid);
            message.tableId.putTo(sink);
            OFFlowRemovedReasonSerializerVer15.putTo(message.reason, sink);
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            message.cookie.putTo(sink);
            message.match.putTo(sink);
            message.stats.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFFlowRemovedVer15> {
        @Override
        public void write(ByteBuf bb, OFFlowRemovedVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property version = 6
            bb.writeByte((byte) 0x6);
            // fixed value property type = 11
            bb.writeByte((byte) 0xb);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeInt(U32.t(message.xid));
            message.tableId.writeByte(bb);
            OFFlowRemovedReasonSerializerVer15.writeTo(bb, message.reason);
            bb.writeShort(U16.t(message.priority));
            bb.writeShort(U16.t(message.idleTimeout));
            bb.writeShort(U16.t(message.hardTimeout));
            bb.writeLong(message.cookie.getValue());
            message.match.writeTo(bb);
            message.stats.writeTo(bb);

            // update length field
            int length = bb.writerIndex() - startIndex;
            if (length > MAXIMUM_LENGTH) {
                throw new IllegalArgumentException("OFFlowRemovedVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowRemovedVer15(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("tableId=").append(tableId);
        b.append(", ");
        b.append("reason=").append(reason);
        b.append(", ");
        b.append("priority=").append(priority);
        b.append(", ");
        b.append("idleTimeout=").append(idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(hardTimeout);
        b.append(", ");
        b.append("cookie=").append(cookie);
        b.append(", ");
        b.append("match=").append(match);
        b.append(", ");
        b.append("stats=").append(stats);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFFlowRemovedVer15 other = (OFFlowRemovedVer15) obj;

        if( xid != other.xid)
            return false;
        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if (reason == null) {
            if (other.reason != null)
                return false;
        } else if (!reason.equals(other.reason))
            return false;
        if( priority != other.priority)
            return false;
        if( idleTimeout != other.idleTimeout)
            return false;
        if( hardTimeout != other.hardTimeout)
            return false;
        if (cookie == null) {
            if (other.cookie != null)
                return false;
        } else if (!cookie.equals(other.cookie))
            return false;
        if (match == null) {
            if (other.match != null)
                return false;
        } else if (!match.equals(other.match))
            return false;
        if (stats == null) {
            if (other.stats != null)
                return false;
        } else if (!stats.equals(other.stats))
            return false;
        return true;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFFlowRemovedVer15 other = (OFFlowRemovedVer15) obj;

        // ignore XID
        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if (reason == null) {
            if (other.reason != null)
                return false;
        } else if (!reason.equals(other.reason))
            return false;
        if( priority != other.priority)
            return false;
        if( idleTimeout != other.idleTimeout)
            return false;
        if( hardTimeout != other.hardTimeout)
            return false;
        if (cookie == null) {
            if (other.cookie != null)
                return false;
        } else if (!cookie.equals(other.cookie))
            return false;
        if (match == null) {
            if (other.match != null)
                return false;
        } else if (!match.equals(other.match))
            return false;
        if (stats == null) {
            if (other.stats != null)
                return false;
        } else if (!stats.equals(other.stats))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime * result + ((reason == null) ? 0 : reason.hashCode());
        result = prime * result + priority;
        result = prime * result + idleTimeout;
        result = prime * result + hardTimeout;
        result = prime * result + ((cookie == null) ? 0 : cookie.hashCode());
        result = prime * result + ((match == null) ? 0 : match.hashCode());
        result = prime * result + ((stats == null) ? 0 : stats.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        final int prime = 31;
        int result = 1;

        // ignore XID
        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime * result + ((reason == null) ? 0 : reason.hashCode());
        result = prime * result + priority;
        result = prime * result + idleTimeout;
        result = prime * result + hardTimeout;
        result = prime * result + ((cookie == null) ? 0 : cookie.hashCode());
        result = prime * result + ((match == null) ? 0 : match.hashCode());
        result = prime * result + ((stats == null) ? 0 : stats.hashCode());
        return result;
    }

}
