// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver11;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFMatchV2Ver11 implements OFMatchV2 {
    private static final Logger logger = LoggerFactory.getLogger(OFMatchV2Ver11.class);
    // version: 1.1
    final static byte WIRE_VERSION = 2;
    final static int LENGTH = 88;

        private final static OFPort DEFAULT_IN_PORT = OFPort.ANY;
        private final static int DEFAULT_WILDCARDS = OFFlowWildcardsSerializerVer11.ALL_VAL;
        private final static MacAddress DEFAULT_ETH_SRC = MacAddress.NONE;
        private final static MacAddress DEFAULT_ETH_SRC_MASK = MacAddress.NONE;
        private final static MacAddress DEFAULT_ETH_DST = MacAddress.NONE;
        private final static MacAddress DEFAULT_ETH_DST_MASK = MacAddress.NONE;
        private final static int DEFAULT_VLAN_VID = 0x0;
        private final static short DEFAULT_VLAN_PCP = (short) 0x0;
        private final static int DEFAULT_ETH_TYPE = 0x0;
        private final static short DEFAULT_IP_DSCP = (short) 0x0;
        private final static short DEFAULT_IP_PROTO = (short) 0x0;
        private final static IPv4Address DEFAULT_IPV4_SRC = IPv4Address.NONE;
        private final static IPv4Address DEFAULT_IPV4_SRC_MASK = IPv4Address.NONE;
        private final static IPv4Address DEFAULT_IPV4_DST = IPv4Address.NONE;
        private final static IPv4Address DEFAULT_IPV4_DST_MASK = IPv4Address.NONE;
        private final static int DEFAULT_TCP_SRC = 0x0;
        private final static int DEFAULT_TCP_DST = 0x0;
        private final static long DEFAULT_MPLS_LABEL = 0x0L;
        private final static short DEFAULT_MPLS_TC = (short) 0x0;
        private final static U64 DEFAULT_METADATA = U64.ZERO;
        private final static U64 DEFAULT_METADATA_MASK = U64.ZERO;

    // OF message fields
    private final OFPort inPort;
    private final int wildcards;
    private final MacAddress ethSrc;
    private final MacAddress ethSrcMask;
    private final MacAddress ethDst;
    private final MacAddress ethDstMask;
    private final int vlanVid;
    private final short vlanPcp;
    private final int ethType;
    private final short ipDscp;
    private final short ipProto;
    private final IPv4Address ipv4Src;
    private final IPv4Address ipv4SrcMask;
    private final IPv4Address ipv4Dst;
    private final IPv4Address ipv4DstMask;
    private final int tcpSrc;
    private final int tcpDst;
    private final long mplsLabel;
    private final short mplsTc;
    private final U64 metadata;
    private final U64 metadataMask;
//
    // Immutable default instance
    final static OFMatchV2Ver11 DEFAULT = new OFMatchV2Ver11(
        DEFAULT_IN_PORT, DEFAULT_WILDCARDS, DEFAULT_ETH_SRC, DEFAULT_ETH_SRC_MASK, DEFAULT_ETH_DST, DEFAULT_ETH_DST_MASK, DEFAULT_VLAN_VID, DEFAULT_VLAN_PCP, DEFAULT_ETH_TYPE, DEFAULT_IP_DSCP, DEFAULT_IP_PROTO, DEFAULT_IPV4_SRC, DEFAULT_IPV4_SRC_MASK, DEFAULT_IPV4_DST, DEFAULT_IPV4_DST_MASK, DEFAULT_TCP_SRC, DEFAULT_TCP_DST, DEFAULT_MPLS_LABEL, DEFAULT_MPLS_TC, DEFAULT_METADATA, DEFAULT_METADATA_MASK
    );

    // package private constructor - used by readers, builders, and factory
    OFMatchV2Ver11(OFPort inPort, int wildcards, MacAddress ethSrc, MacAddress ethSrcMask, MacAddress ethDst, MacAddress ethDstMask, int vlanVid, short vlanPcp, int ethType, short ipDscp, short ipProto, IPv4Address ipv4Src, IPv4Address ipv4SrcMask, IPv4Address ipv4Dst, IPv4Address ipv4DstMask, int tcpSrc, int tcpDst, long mplsLabel, short mplsTc, U64 metadata, U64 metadataMask) {
        if(inPort == null) {
            throw new NullPointerException("OFMatchV2Ver11: property inPort cannot be null");
        }
        if(ethSrc == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethSrc cannot be null");
        }
        if(ethSrcMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethSrcMask cannot be null");
        }
        if(ethDst == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethDst cannot be null");
        }
        if(ethDstMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ethDstMask cannot be null");
        }
        if(ipv4Src == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4Src cannot be null");
        }
        if(ipv4SrcMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4SrcMask cannot be null");
        }
        if(ipv4Dst == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4Dst cannot be null");
        }
        if(ipv4DstMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property ipv4DstMask cannot be null");
        }
        if(metadata == null) {
            throw new NullPointerException("OFMatchV2Ver11: property metadata cannot be null");
        }
        if(metadataMask == null) {
            throw new NullPointerException("OFMatchV2Ver11: property metadataMask cannot be null");
        }
        this.inPort = inPort;
        this.wildcards = wildcards;
        this.ethSrc = ethSrc;
        this.ethSrcMask = ethSrcMask;
        this.ethDst = ethDst;
        this.ethDstMask = ethDstMask;
        this.vlanVid = U16.normalize(vlanVid);
        this.vlanPcp = U8.normalize(vlanPcp);
        this.ethType = U16.normalize(ethType);
        this.ipDscp = U8.normalize(ipDscp);
        this.ipProto = U8.normalize(ipProto);
        this.ipv4Src = ipv4Src;
        this.ipv4SrcMask = ipv4SrcMask;
        this.ipv4Dst = ipv4Dst;
        this.ipv4DstMask = ipv4DstMask;
        this.tcpSrc = U16.normalize(tcpSrc);
        this.tcpDst = U16.normalize(tcpDst);
        this.mplsLabel = U32.normalize(mplsLabel);
        this.mplsTc = U8.normalize(mplsTc);
        this.metadata = metadata;
        this.metadataMask = metadataMask;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0x0;
    }

    @Override
    public OFPort getInPort() {
        return inPort;
    }

    @Override
    public int getWildcards() {
        return wildcards;
    }

    @Override
    public MacAddress getEthSrc() {
        return ethSrc;
    }

    @Override
    public MacAddress getEthSrcMask() {
        return ethSrcMask;
    }

    @Override
    public MacAddress getEthDst() {
        return ethDst;
    }

    @Override
    public MacAddress getEthDstMask() {
        return ethDstMask;
    }

    @Override
    public int getVlanVid() {
        return vlanVid;
    }

    @Override
    public short getVlanPcp() {
        return vlanPcp;
    }

    @Override
    public int getEthType() {
        return ethType;
    }

    @Override
    public short getIpDscp() {
        return ipDscp;
    }

    @Override
    public short getIpProto() {
        return ipProto;
    }

    @Override
    public IPv4Address getIpv4Src() {
        return ipv4Src;
    }

    @Override
    public IPv4Address getIpv4SrcMask() {
        return ipv4SrcMask;
    }

    @Override
    public IPv4Address getIpv4Dst() {
        return ipv4Dst;
    }

    @Override
    public IPv4Address getIpv4DstMask() {
        return ipv4DstMask;
    }

    @Override
    public int getTcpSrc() {
        return tcpSrc;
    }

    @Override
    public int getTcpDst() {
        return tcpDst;
    }

    @Override
    public long getMplsLabel() {
        return mplsLabel;
    }

    @Override
    public short getMplsTc() {
        return mplsTc;
    }

    @Override
    public U64 getMetadata() {
        return metadata;
    }

    @Override
    public U64 getMetadataMask() {
        return metadataMask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }



    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field)
            throws UnsupportedOperationException {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field)
            throws UnsupportedOperationException {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public Iterable<MatchField<?>> getMatchFields() {
        throw new UnsupportedOperationException();
    }

    public OFMatchV2.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFMatchV2.Builder {
        final OFMatchV2Ver11 parentMessage;

        // OF message fields
        private boolean inPortSet;
        private OFPort inPort;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean ethSrcSet;
        private MacAddress ethSrc;
        private boolean ethSrcMaskSet;
        private MacAddress ethSrcMask;
        private boolean ethDstSet;
        private MacAddress ethDst;
        private boolean ethDstMaskSet;
        private MacAddress ethDstMask;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean vlanPcpSet;
        private short vlanPcp;
        private boolean ethTypeSet;
        private int ethType;
        private boolean ipDscpSet;
        private short ipDscp;
        private boolean ipProtoSet;
        private short ipProto;
        private boolean ipv4SrcSet;
        private IPv4Address ipv4Src;
        private boolean ipv4SrcMaskSet;
        private IPv4Address ipv4SrcMask;
        private boolean ipv4DstSet;
        private IPv4Address ipv4Dst;
        private boolean ipv4DstMaskSet;
        private IPv4Address ipv4DstMask;
        private boolean tcpSrcSet;
        private int tcpSrc;
        private boolean tcpDstSet;
        private int tcpDst;
        private boolean mplsLabelSet;
        private long mplsLabel;
        private boolean mplsTcSet;
        private short mplsTc;
        private boolean metadataSet;
        private U64 metadata;
        private boolean metadataMaskSet;
        private U64 metadataMask;

        BuilderWithParent(OFMatchV2Ver11 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0x0;
    }

    @Override
    public OFPort getInPort() {
        return inPort;
    }

    @Override
    public OFMatchV2.Builder setInPort(OFPort inPort) {
        this.inPort = inPort;
        this.inPortSet = true;
        return this;
    }
    @Override
    public int getWildcards() {
        return wildcards;
    }

    @Override
    public OFMatchV2.Builder setWildcards(int wildcards) {
        this.wildcards = wildcards;
        this.wildcardsSet = true;
        return this;
    }
    @Override
    public MacAddress getEthSrc() {
        return ethSrc;
    }

    @Override
    public OFMatchV2.Builder setEthSrc(MacAddress ethSrc) {
        this.ethSrc = ethSrc;
        this.ethSrcSet = true;
        return this;
    }
    @Override
    public MacAddress getEthSrcMask() {
        return ethSrcMask;
    }

    @Override
    public OFMatchV2.Builder setEthSrcMask(MacAddress ethSrcMask) {
        this.ethSrcMask = ethSrcMask;
        this.ethSrcMaskSet = true;
        return this;
    }
    @Override
    public MacAddress getEthDst() {
        return ethDst;
    }

    @Override
    public OFMatchV2.Builder setEthDst(MacAddress ethDst) {
        this.ethDst = ethDst;
        this.ethDstSet = true;
        return this;
    }
    @Override
    public MacAddress getEthDstMask() {
        return ethDstMask;
    }

    @Override
    public OFMatchV2.Builder setEthDstMask(MacAddress ethDstMask) {
        this.ethDstMask = ethDstMask;
        this.ethDstMaskSet = true;
        return this;
    }
    @Override
    public int getVlanVid() {
        return vlanVid;
    }

    @Override
    public OFMatchV2.Builder setVlanVid(int vlanVid) {
        this.vlanVid = vlanVid;
        this.vlanVidSet = true;
        return this;
    }
    @Override
    public short getVlanPcp() {
        return vlanPcp;
    }

    @Override
    public OFMatchV2.Builder setVlanPcp(short vlanPcp) {
        this.vlanPcp = vlanPcp;
        this.vlanPcpSet = true;
        return this;
    }
    @Override
    public int getEthType() {
        return ethType;
    }

    @Override
    public OFMatchV2.Builder setEthType(int ethType) {
        this.ethType = ethType;
        this.ethTypeSet = true;
        return this;
    }
    @Override
    public short getIpDscp() {
        return ipDscp;
    }

    @Override
    public OFMatchV2.Builder setIpDscp(short ipDscp) {
        this.ipDscp = ipDscp;
        this.ipDscpSet = true;
        return this;
    }
    @Override
    public short getIpProto() {
        return ipProto;
    }

    @Override
    public OFMatchV2.Builder setIpProto(short ipProto) {
        this.ipProto = ipProto;
        this.ipProtoSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4Src() {
        return ipv4Src;
    }

    @Override
    public OFMatchV2.Builder setIpv4Src(IPv4Address ipv4Src) {
        this.ipv4Src = ipv4Src;
        this.ipv4SrcSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4SrcMask() {
        return ipv4SrcMask;
    }

    @Override
    public OFMatchV2.Builder setIpv4SrcMask(IPv4Address ipv4SrcMask) {
        this.ipv4SrcMask = ipv4SrcMask;
        this.ipv4SrcMaskSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4Dst() {
        return ipv4Dst;
    }

    @Override
    public OFMatchV2.Builder setIpv4Dst(IPv4Address ipv4Dst) {
        this.ipv4Dst = ipv4Dst;
        this.ipv4DstSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4DstMask() {
        return ipv4DstMask;
    }

    @Override
    public OFMatchV2.Builder setIpv4DstMask(IPv4Address ipv4DstMask) {
        this.ipv4DstMask = ipv4DstMask;
        this.ipv4DstMaskSet = true;
        return this;
    }
    @Override
    public int getTcpSrc() {
        return tcpSrc;
    }

    @Override
    public OFMatchV2.Builder setTcpSrc(int tcpSrc) {
        this.tcpSrc = tcpSrc;
        this.tcpSrcSet = true;
        return this;
    }
    @Override
    public int getTcpDst() {
        return tcpDst;
    }

    @Override
    public OFMatchV2.Builder setTcpDst(int tcpDst) {
        this.tcpDst = tcpDst;
        this.tcpDstSet = true;
        return this;
    }
    @Override
    public long getMplsLabel() {
        return mplsLabel;
    }

    @Override
    public OFMatchV2.Builder setMplsLabel(long mplsLabel) {
        this.mplsLabel = mplsLabel;
        this.mplsLabelSet = true;
        return this;
    }
    @Override
    public short getMplsTc() {
        return mplsTc;
    }

    @Override
    public OFMatchV2.Builder setMplsTc(short mplsTc) {
        this.mplsTc = mplsTc;
        this.mplsTcSet = true;
        return this;
    }
    @Override
    public U64 getMetadata() {
        return metadata;
    }

    @Override
    public OFMatchV2.Builder setMetadata(U64 metadata) {
        this.metadata = metadata;
        this.metadataSet = true;
        return this;
    }
    @Override
    public U64 getMetadataMask() {
        return metadataMask;
    }

    @Override
    public OFMatchV2.Builder setMetadataMask(U64 metadataMask) {
        this.metadataMask = metadataMask;
        this.metadataMaskSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }



        @Override
        public OFMatchV2 build() {
                OFPort inPort = this.inPortSet ? this.inPort : parentMessage.inPort;
                if(inPort == null)
                    throw new NullPointerException("Property inPort must not be null");
                int wildcards = this.wildcardsSet ? this.wildcards : parentMessage.wildcards;
                MacAddress ethSrc = this.ethSrcSet ? this.ethSrc : parentMessage.ethSrc;
                if(ethSrc == null)
                    throw new NullPointerException("Property ethSrc must not be null");
                MacAddress ethSrcMask = this.ethSrcMaskSet ? this.ethSrcMask : parentMessage.ethSrcMask;
                if(ethSrcMask == null)
                    throw new NullPointerException("Property ethSrcMask must not be null");
                MacAddress ethDst = this.ethDstSet ? this.ethDst : parentMessage.ethDst;
                if(ethDst == null)
                    throw new NullPointerException("Property ethDst must not be null");
                MacAddress ethDstMask = this.ethDstMaskSet ? this.ethDstMask : parentMessage.ethDstMask;
                if(ethDstMask == null)
                    throw new NullPointerException("Property ethDstMask must not be null");
                int vlanVid = this.vlanVidSet ? this.vlanVid : parentMessage.vlanVid;
                short vlanPcp = this.vlanPcpSet ? this.vlanPcp : parentMessage.vlanPcp;
                int ethType = this.ethTypeSet ? this.ethType : parentMessage.ethType;
                short ipDscp = this.ipDscpSet ? this.ipDscp : parentMessage.ipDscp;
                short ipProto = this.ipProtoSet ? this.ipProto : parentMessage.ipProto;
                IPv4Address ipv4Src = this.ipv4SrcSet ? this.ipv4Src : parentMessage.ipv4Src;
                if(ipv4Src == null)
                    throw new NullPointerException("Property ipv4Src must not be null");
                IPv4Address ipv4SrcMask = this.ipv4SrcMaskSet ? this.ipv4SrcMask : parentMessage.ipv4SrcMask;
                if(ipv4SrcMask == null)
                    throw new NullPointerException("Property ipv4SrcMask must not be null");
                IPv4Address ipv4Dst = this.ipv4DstSet ? this.ipv4Dst : parentMessage.ipv4Dst;
                if(ipv4Dst == null)
                    throw new NullPointerException("Property ipv4Dst must not be null");
                IPv4Address ipv4DstMask = this.ipv4DstMaskSet ? this.ipv4DstMask : parentMessage.ipv4DstMask;
                if(ipv4DstMask == null)
                    throw new NullPointerException("Property ipv4DstMask must not be null");
                int tcpSrc = this.tcpSrcSet ? this.tcpSrc : parentMessage.tcpSrc;
                int tcpDst = this.tcpDstSet ? this.tcpDst : parentMessage.tcpDst;
                long mplsLabel = this.mplsLabelSet ? this.mplsLabel : parentMessage.mplsLabel;
                short mplsTc = this.mplsTcSet ? this.mplsTc : parentMessage.mplsTc;
                U64 metadata = this.metadataSet ? this.metadata : parentMessage.metadata;
                if(metadata == null)
                    throw new NullPointerException("Property metadata must not be null");
                U64 metadataMask = this.metadataMaskSet ? this.metadataMask : parentMessage.metadataMask;
                if(metadataMask == null)
                    throw new NullPointerException("Property metadataMask must not be null");

                //
                return new OFMatchV2Ver11(
                    inPort,
                    wildcards,
                    ethSrc,
                    ethSrcMask,
                    ethDst,
                    ethDstMask,
                    vlanVid,
                    vlanPcp,
                    ethType,
                    ipDscp,
                    ipProto,
                    ipv4Src,
                    ipv4SrcMask,
                    ipv4Dst,
                    ipv4DstMask,
                    tcpSrc,
                    tcpDst,
                    mplsLabel,
                    mplsTc,
                    metadata,
                    metadataMask
                );
        }

    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field)
            throws UnsupportedOperationException {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field)
            throws UnsupportedOperationException {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder setExact(
            MatchField<F> field, F value) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder setMasked(
            MatchField<F> field, F value, F mask) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder setMasked(
            MatchField<F> field, Masked<F> valueWithMask) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    }

    static class Builder implements OFMatchV2.Builder {
        // OF message fields
        private boolean inPortSet;
        private OFPort inPort;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean ethSrcSet;
        private MacAddress ethSrc;
        private boolean ethSrcMaskSet;
        private MacAddress ethSrcMask;
        private boolean ethDstSet;
        private MacAddress ethDst;
        private boolean ethDstMaskSet;
        private MacAddress ethDstMask;
        private boolean vlanVidSet;
        private int vlanVid;
        private boolean vlanPcpSet;
        private short vlanPcp;
        private boolean ethTypeSet;
        private int ethType;
        private boolean ipDscpSet;
        private short ipDscp;
        private boolean ipProtoSet;
        private short ipProto;
        private boolean ipv4SrcSet;
        private IPv4Address ipv4Src;
        private boolean ipv4SrcMaskSet;
        private IPv4Address ipv4SrcMask;
        private boolean ipv4DstSet;
        private IPv4Address ipv4Dst;
        private boolean ipv4DstMaskSet;
        private IPv4Address ipv4DstMask;
        private boolean tcpSrcSet;
        private int tcpSrc;
        private boolean tcpDstSet;
        private int tcpDst;
        private boolean mplsLabelSet;
        private long mplsLabel;
        private boolean mplsTcSet;
        private short mplsTc;
        private boolean metadataSet;
        private U64 metadata;
        private boolean metadataMaskSet;
        private U64 metadataMask;

    @Override
    public int getType() {
        return 0x0;
    }

    @Override
    public OFPort getInPort() {
        return inPort;
    }

    @Override
    public OFMatchV2.Builder setInPort(OFPort inPort) {
        this.inPort = inPort;
        this.inPortSet = true;
        return this;
    }
    @Override
    public int getWildcards() {
        return wildcards;
    }

    @Override
    public OFMatchV2.Builder setWildcards(int wildcards) {
        this.wildcards = wildcards;
        this.wildcardsSet = true;
        return this;
    }
    @Override
    public MacAddress getEthSrc() {
        return ethSrc;
    }

    @Override
    public OFMatchV2.Builder setEthSrc(MacAddress ethSrc) {
        this.ethSrc = ethSrc;
        this.ethSrcSet = true;
        return this;
    }
    @Override
    public MacAddress getEthSrcMask() {
        return ethSrcMask;
    }

    @Override
    public OFMatchV2.Builder setEthSrcMask(MacAddress ethSrcMask) {
        this.ethSrcMask = ethSrcMask;
        this.ethSrcMaskSet = true;
        return this;
    }
    @Override
    public MacAddress getEthDst() {
        return ethDst;
    }

    @Override
    public OFMatchV2.Builder setEthDst(MacAddress ethDst) {
        this.ethDst = ethDst;
        this.ethDstSet = true;
        return this;
    }
    @Override
    public MacAddress getEthDstMask() {
        return ethDstMask;
    }

    @Override
    public OFMatchV2.Builder setEthDstMask(MacAddress ethDstMask) {
        this.ethDstMask = ethDstMask;
        this.ethDstMaskSet = true;
        return this;
    }
    @Override
    public int getVlanVid() {
        return vlanVid;
    }

    @Override
    public OFMatchV2.Builder setVlanVid(int vlanVid) {
        this.vlanVid = vlanVid;
        this.vlanVidSet = true;
        return this;
    }
    @Override
    public short getVlanPcp() {
        return vlanPcp;
    }

    @Override
    public OFMatchV2.Builder setVlanPcp(short vlanPcp) {
        this.vlanPcp = vlanPcp;
        this.vlanPcpSet = true;
        return this;
    }
    @Override
    public int getEthType() {
        return ethType;
    }

    @Override
    public OFMatchV2.Builder setEthType(int ethType) {
        this.ethType = ethType;
        this.ethTypeSet = true;
        return this;
    }
    @Override
    public short getIpDscp() {
        return ipDscp;
    }

    @Override
    public OFMatchV2.Builder setIpDscp(short ipDscp) {
        this.ipDscp = ipDscp;
        this.ipDscpSet = true;
        return this;
    }
    @Override
    public short getIpProto() {
        return ipProto;
    }

    @Override
    public OFMatchV2.Builder setIpProto(short ipProto) {
        this.ipProto = ipProto;
        this.ipProtoSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4Src() {
        return ipv4Src;
    }

    @Override
    public OFMatchV2.Builder setIpv4Src(IPv4Address ipv4Src) {
        this.ipv4Src = ipv4Src;
        this.ipv4SrcSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4SrcMask() {
        return ipv4SrcMask;
    }

    @Override
    public OFMatchV2.Builder setIpv4SrcMask(IPv4Address ipv4SrcMask) {
        this.ipv4SrcMask = ipv4SrcMask;
        this.ipv4SrcMaskSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4Dst() {
        return ipv4Dst;
    }

    @Override
    public OFMatchV2.Builder setIpv4Dst(IPv4Address ipv4Dst) {
        this.ipv4Dst = ipv4Dst;
        this.ipv4DstSet = true;
        return this;
    }
    @Override
    public IPv4Address getIpv4DstMask() {
        return ipv4DstMask;
    }

    @Override
    public OFMatchV2.Builder setIpv4DstMask(IPv4Address ipv4DstMask) {
        this.ipv4DstMask = ipv4DstMask;
        this.ipv4DstMaskSet = true;
        return this;
    }
    @Override
    public int getTcpSrc() {
        return tcpSrc;
    }

    @Override
    public OFMatchV2.Builder setTcpSrc(int tcpSrc) {
        this.tcpSrc = tcpSrc;
        this.tcpSrcSet = true;
        return this;
    }
    @Override
    public int getTcpDst() {
        return tcpDst;
    }

    @Override
    public OFMatchV2.Builder setTcpDst(int tcpDst) {
        this.tcpDst = tcpDst;
        this.tcpDstSet = true;
        return this;
    }
    @Override
    public long getMplsLabel() {
        return mplsLabel;
    }

    @Override
    public OFMatchV2.Builder setMplsLabel(long mplsLabel) {
        this.mplsLabel = mplsLabel;
        this.mplsLabelSet = true;
        return this;
    }
    @Override
    public short getMplsTc() {
        return mplsTc;
    }

    @Override
    public OFMatchV2.Builder setMplsTc(short mplsTc) {
        this.mplsTc = mplsTc;
        this.mplsTcSet = true;
        return this;
    }
    @Override
    public U64 getMetadata() {
        return metadata;
    }

    @Override
    public OFMatchV2.Builder setMetadata(U64 metadata) {
        this.metadata = metadata;
        this.metadataSet = true;
        return this;
    }
    @Override
    public U64 getMetadataMask() {
        return metadataMask;
    }

    @Override
    public OFMatchV2.Builder setMetadataMask(U64 metadataMask) {
        this.metadataMask = metadataMask;
        this.metadataMaskSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

//
        @Override
        public OFMatchV2 build() {
            OFPort inPort = this.inPortSet ? this.inPort : DEFAULT_IN_PORT;
            if(inPort == null)
                throw new NullPointerException("Property inPort must not be null");
            int wildcards = this.wildcardsSet ? this.wildcards : DEFAULT_WILDCARDS;
            MacAddress ethSrc = this.ethSrcSet ? this.ethSrc : DEFAULT_ETH_SRC;
            if(ethSrc == null)
                throw new NullPointerException("Property ethSrc must not be null");
            MacAddress ethSrcMask = this.ethSrcMaskSet ? this.ethSrcMask : DEFAULT_ETH_SRC_MASK;
            if(ethSrcMask == null)
                throw new NullPointerException("Property ethSrcMask must not be null");
            MacAddress ethDst = this.ethDstSet ? this.ethDst : DEFAULT_ETH_DST;
            if(ethDst == null)
                throw new NullPointerException("Property ethDst must not be null");
            MacAddress ethDstMask = this.ethDstMaskSet ? this.ethDstMask : DEFAULT_ETH_DST_MASK;
            if(ethDstMask == null)
                throw new NullPointerException("Property ethDstMask must not be null");
            int vlanVid = this.vlanVidSet ? this.vlanVid : DEFAULT_VLAN_VID;
            short vlanPcp = this.vlanPcpSet ? this.vlanPcp : DEFAULT_VLAN_PCP;
            int ethType = this.ethTypeSet ? this.ethType : DEFAULT_ETH_TYPE;
            short ipDscp = this.ipDscpSet ? this.ipDscp : DEFAULT_IP_DSCP;
            short ipProto = this.ipProtoSet ? this.ipProto : DEFAULT_IP_PROTO;
            IPv4Address ipv4Src = this.ipv4SrcSet ? this.ipv4Src : DEFAULT_IPV4_SRC;
            if(ipv4Src == null)
                throw new NullPointerException("Property ipv4Src must not be null");
            IPv4Address ipv4SrcMask = this.ipv4SrcMaskSet ? this.ipv4SrcMask : DEFAULT_IPV4_SRC_MASK;
            if(ipv4SrcMask == null)
                throw new NullPointerException("Property ipv4SrcMask must not be null");
            IPv4Address ipv4Dst = this.ipv4DstSet ? this.ipv4Dst : DEFAULT_IPV4_DST;
            if(ipv4Dst == null)
                throw new NullPointerException("Property ipv4Dst must not be null");
            IPv4Address ipv4DstMask = this.ipv4DstMaskSet ? this.ipv4DstMask : DEFAULT_IPV4_DST_MASK;
            if(ipv4DstMask == null)
                throw new NullPointerException("Property ipv4DstMask must not be null");
            int tcpSrc = this.tcpSrcSet ? this.tcpSrc : DEFAULT_TCP_SRC;
            int tcpDst = this.tcpDstSet ? this.tcpDst : DEFAULT_TCP_DST;
            long mplsLabel = this.mplsLabelSet ? this.mplsLabel : DEFAULT_MPLS_LABEL;
            short mplsTc = this.mplsTcSet ? this.mplsTc : DEFAULT_MPLS_TC;
            U64 metadata = this.metadataSet ? this.metadata : DEFAULT_METADATA;
            if(metadata == null)
                throw new NullPointerException("Property metadata must not be null");
            U64 metadataMask = this.metadataMaskSet ? this.metadataMask : DEFAULT_METADATA_MASK;
            if(metadataMask == null)
                throw new NullPointerException("Property metadataMask must not be null");


            return new OFMatchV2Ver11(
                    inPort,
                    wildcards,
                    ethSrc,
                    ethSrcMask,
                    ethDst,
                    ethDstMask,
                    vlanVid,
                    vlanPcp,
                    ethType,
                    ipDscp,
                    ipProto,
                    ipv4Src,
                    ipv4SrcMask,
                    ipv4Dst,
                    ipv4DstMask,
                    tcpSrc,
                    tcpDst,
                    mplsLabel,
                    mplsTc,
                    metadata,
                    metadataMask
                );
        }

    @Override
    public <F extends OFValueType<F>> F get(MatchField<F> field)
            throws UnsupportedOperationException {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Masked<F> getMasked(MatchField<F> field)
            throws UnsupportedOperationException {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public boolean supports(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean supportsMasked(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isExact(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isFullyWildcarded(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public boolean isPartiallyMasked(MatchField<?> field) {
        // FIXME yotam - please replace with real implementation
        return false;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder setExact(
            MatchField<F> field, F value) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder setMasked(
            MatchField<F> field, F value, F mask) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder setMasked(
            MatchField<F> field, Masked<F> valueWithMask) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    @Override
    public <F extends OFValueType<F>> Match.Builder wildcard(MatchField<F> field) {
        // FIXME yotam - please replace with real implementation
        return null;
    }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFMatchV2> {
        @Override
        public OFMatchV2 readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0x0
            short type = bb.readShort();
            if(type != (short) 0x0)
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 88)
                throw new OFParseError("Wrong length: Expected=88(88), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            OFPort inPort = OFPort.read4Bytes(bb);
            int wildcards = bb.readInt();
            MacAddress ethSrc = MacAddress.read6Bytes(bb);
            MacAddress ethSrcMask = MacAddress.read6Bytes(bb);
            MacAddress ethDst = MacAddress.read6Bytes(bb);
            MacAddress ethDstMask = MacAddress.read6Bytes(bb);
            int vlanVid = U16.f(bb.readShort());
            short vlanPcp = U8.f(bb.readByte());
            // pad: 1 bytes
            bb.skipBytes(1);
            int ethType = U16.f(bb.readShort());
            short ipDscp = U8.f(bb.readByte());
            short ipProto = U8.f(bb.readByte());
            IPv4Address ipv4Src = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4SrcMask = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4Dst = IPv4Address.read4Bytes(bb);
            IPv4Address ipv4DstMask = IPv4Address.read4Bytes(bb);
            int tcpSrc = U16.f(bb.readShort());
            int tcpDst = U16.f(bb.readShort());
            long mplsLabel = U32.f(bb.readInt());
            short mplsTc = U8.f(bb.readByte());
            // pad: 3 bytes
            bb.skipBytes(3);
            U64 metadata = U64.ofRaw(bb.readLong());
            U64 metadataMask = U64.ofRaw(bb.readLong());

            OFMatchV2Ver11 matchV2Ver11 = new OFMatchV2Ver11(
                    inPort,
                      wildcards,
                      ethSrc,
                      ethSrcMask,
                      ethDst,
                      ethDstMask,
                      vlanVid,
                      vlanPcp,
                      ethType,
                      ipDscp,
                      ipProto,
                      ipv4Src,
                      ipv4SrcMask,
                      ipv4Dst,
                      ipv4DstMask,
                      tcpSrc,
                      tcpDst,
                      mplsLabel,
                      mplsTc,
                      metadata,
                      metadataMask
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", matchV2Ver11);
            return matchV2Ver11;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFMatchV2Ver11Funnel FUNNEL = new OFMatchV2Ver11Funnel();
    static class OFMatchV2Ver11Funnel implements Funnel<OFMatchV2Ver11> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFMatchV2Ver11 message, PrimitiveSink sink) {
            // fixed value property type = 0x0
            sink.putShort((short) 0x0);
            // fixed value property length = 88
            sink.putShort((short) 0x58);
            message.inPort.putTo(sink);
            sink.putInt(message.wildcards);
            message.ethSrc.putTo(sink);
            message.ethSrcMask.putTo(sink);
            message.ethDst.putTo(sink);
            message.ethDstMask.putTo(sink);
            sink.putInt(message.vlanVid);
            sink.putShort(message.vlanPcp);
            // skip pad (1 bytes)
            sink.putInt(message.ethType);
            sink.putShort(message.ipDscp);
            sink.putShort(message.ipProto);
            message.ipv4Src.putTo(sink);
            message.ipv4SrcMask.putTo(sink);
            message.ipv4Dst.putTo(sink);
            message.ipv4DstMask.putTo(sink);
            sink.putInt(message.tcpSrc);
            sink.putInt(message.tcpDst);
            sink.putLong(message.mplsLabel);
            sink.putShort(message.mplsTc);
            // skip pad (3 bytes)
            message.metadata.putTo(sink);
            message.metadataMask.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFMatchV2Ver11> {
        @Override
        public void write(ByteBuf bb, OFMatchV2Ver11 message) {
            // fixed value property type = 0x0
            bb.writeShort((short) 0x0);
            // fixed value property length = 88
            bb.writeShort((short) 0x58);
            message.inPort.write4Bytes(bb);
            bb.writeInt(message.wildcards);
            message.ethSrc.write6Bytes(bb);
            message.ethSrcMask.write6Bytes(bb);
            message.ethDst.write6Bytes(bb);
            message.ethDstMask.write6Bytes(bb);
            bb.writeShort(U16.t(message.vlanVid));
            bb.writeByte(U8.t(message.vlanPcp));
            // pad: 1 bytes
            bb.writeZero(1);
            bb.writeShort(U16.t(message.ethType));
            bb.writeByte(U8.t(message.ipDscp));
            bb.writeByte(U8.t(message.ipProto));
            message.ipv4Src.write4Bytes(bb);
            message.ipv4SrcMask.write4Bytes(bb);
            message.ipv4Dst.write4Bytes(bb);
            message.ipv4DstMask.write4Bytes(bb);
            bb.writeShort(U16.t(message.tcpSrc));
            bb.writeShort(U16.t(message.tcpDst));
            bb.writeInt(U32.t(message.mplsLabel));
            bb.writeByte(U8.t(message.mplsTc));
            // pad: 3 bytes
            bb.writeZero(3);
            bb.writeLong(message.metadata.getValue());
            bb.writeLong(message.metadataMask.getValue());


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFMatchV2Ver11(");
        b.append("inPort=").append(inPort);
        b.append(", ");
        b.append("wildcards=").append(wildcards);
        b.append(", ");
        b.append("ethSrc=").append(ethSrc);
        b.append(", ");
        b.append("ethSrcMask=").append(ethSrcMask);
        b.append(", ");
        b.append("ethDst=").append(ethDst);
        b.append(", ");
        b.append("ethDstMask=").append(ethDstMask);
        b.append(", ");
        b.append("vlanVid=").append(vlanVid);
        b.append(", ");
        b.append("vlanPcp=").append(vlanPcp);
        b.append(", ");
        b.append("ethType=").append(ethType);
        b.append(", ");
        b.append("ipDscp=").append(ipDscp);
        b.append(", ");
        b.append("ipProto=").append(ipProto);
        b.append(", ");
        b.append("ipv4Src=").append(ipv4Src);
        b.append(", ");
        b.append("ipv4SrcMask=").append(ipv4SrcMask);
        b.append(", ");
        b.append("ipv4Dst=").append(ipv4Dst);
        b.append(", ");
        b.append("ipv4DstMask=").append(ipv4DstMask);
        b.append(", ");
        b.append("tcpSrc=").append(tcpSrc);
        b.append(", ");
        b.append("tcpDst=").append(tcpDst);
        b.append(", ");
        b.append("mplsLabel=").append(mplsLabel);
        b.append(", ");
        b.append("mplsTc=").append(mplsTc);
        b.append(", ");
        b.append("metadata=").append(metadata);
        b.append(", ");
        b.append("metadataMask=").append(metadataMask);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFMatchV2Ver11 other = (OFMatchV2Ver11) obj;

        if (inPort == null) {
            if (other.inPort != null)
                return false;
        } else if (!inPort.equals(other.inPort))
            return false;
        if( wildcards != other.wildcards)
            return false;
        if (ethSrc == null) {
            if (other.ethSrc != null)
                return false;
        } else if (!ethSrc.equals(other.ethSrc))
            return false;
        if (ethSrcMask == null) {
            if (other.ethSrcMask != null)
                return false;
        } else if (!ethSrcMask.equals(other.ethSrcMask))
            return false;
        if (ethDst == null) {
            if (other.ethDst != null)
                return false;
        } else if (!ethDst.equals(other.ethDst))
            return false;
        if (ethDstMask == null) {
            if (other.ethDstMask != null)
                return false;
        } else if (!ethDstMask.equals(other.ethDstMask))
            return false;
        if( vlanVid != other.vlanVid)
            return false;
        if( vlanPcp != other.vlanPcp)
            return false;
        if( ethType != other.ethType)
            return false;
        if( ipDscp != other.ipDscp)
            return false;
        if( ipProto != other.ipProto)
            return false;
        if (ipv4Src == null) {
            if (other.ipv4Src != null)
                return false;
        } else if (!ipv4Src.equals(other.ipv4Src))
            return false;
        if (ipv4SrcMask == null) {
            if (other.ipv4SrcMask != null)
                return false;
        } else if (!ipv4SrcMask.equals(other.ipv4SrcMask))
            return false;
        if (ipv4Dst == null) {
            if (other.ipv4Dst != null)
                return false;
        } else if (!ipv4Dst.equals(other.ipv4Dst))
            return false;
        if (ipv4DstMask == null) {
            if (other.ipv4DstMask != null)
                return false;
        } else if (!ipv4DstMask.equals(other.ipv4DstMask))
            return false;
        if( tcpSrc != other.tcpSrc)
            return false;
        if( tcpDst != other.tcpDst)
            return false;
        if( mplsLabel != other.mplsLabel)
            return false;
        if( mplsTc != other.mplsTc)
            return false;
        if (metadata == null) {
            if (other.metadata != null)
                return false;
        } else if (!metadata.equals(other.metadata))
            return false;
        if (metadataMask == null) {
            if (other.metadataMask != null)
                return false;
        } else if (!metadataMask.equals(other.metadataMask))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((inPort == null) ? 0 : inPort.hashCode());
        result = prime * result + wildcards;
        result = prime * result + ((ethSrc == null) ? 0 : ethSrc.hashCode());
        result = prime * result + ((ethSrcMask == null) ? 0 : ethSrcMask.hashCode());
        result = prime * result + ((ethDst == null) ? 0 : ethDst.hashCode());
        result = prime * result + ((ethDstMask == null) ? 0 : ethDstMask.hashCode());
        result = prime * result + vlanVid;
        result = prime * result + vlanPcp;
        result = prime * result + ethType;
        result = prime * result + ipDscp;
        result = prime * result + ipProto;
        result = prime * result + ((ipv4Src == null) ? 0 : ipv4Src.hashCode());
        result = prime * result + ((ipv4SrcMask == null) ? 0 : ipv4SrcMask.hashCode());
        result = prime * result + ((ipv4Dst == null) ? 0 : ipv4Dst.hashCode());
        result = prime * result + ((ipv4DstMask == null) ? 0 : ipv4DstMask.hashCode());
        result = prime * result + tcpSrc;
        result = prime * result + tcpDst;
        result = prime *  (int) (mplsLabel ^ (mplsLabel >>> 32));
        result = prime * result + mplsTc;
        result = prime * result + ((metadata == null) ? 0 : metadata.hashCode());
        result = prime * result + ((metadataMask == null) ? 0 : metadataMask.hashCode());
        return result;
    }

}
