/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.types.U64;

public class U64Test {
    private Triple[] triples;

    @Test
    public void testPositiveRaws() {
        for (long positive : new long[]{0L, 1L, 100L, Long.MAX_VALUE}) {
            Assert.assertEquals((long)positive, (long)U64.ofRaw((long)positive).getValue());
            Assert.assertEquals((Object)BigInteger.valueOf(positive), (Object)U64.ofRaw((long)positive).getBigInteger());
        }
    }

    @Test
    public void testNegativeRaws() {
        long minu1 = -1L;
        Assert.assertEquals((long)minu1, (long)U64.ofRaw((long)minu1).getValue());
        Assert.assertEquals((Object)new BigInteger("FFFF_FFFF_FFFF_FFFF".replace("_", ""), 16), (Object)U64.ofRaw((long)minu1).getBigInteger());
        Assert.assertEquals((Object)new BigInteger("18446744073709551615"), (Object)U64.ofRaw((long)minu1).getBigInteger());
    }

    @Test
    public void testEqualHashCode() {
        U64 h1 = U64.of((long)-2400490138922795281L);
        U64 h2 = U64.of((long)-2400490138922795281L);
        U64 h3 = U64.of((long)-1247568634315948305L);
        Assert.assertTrue((boolean)h1.equals((Object)h1));
        Assert.assertTrue((boolean)h1.equals((Object)h2));
        Assert.assertFalse((boolean)h1.equals((Object)h3));
        Assert.assertTrue((boolean)h2.equals((Object)h1));
        Assert.assertEquals((long)h1.hashCode(), (long)h2.hashCode());
        Assert.assertNotEquals((long)h1.hashCode(), (long)h3.hashCode());
    }

    @Test
    public void testXor() {
        U64 hNull = U64.of((long)0L);
        U64 hDeadBeef = U64.of((long)-2400490138922795281L);
        MatcherAssert.assertThat((Object)hNull.xor(hNull), (Matcher)CoreMatchers.equalTo((Object)hNull));
        MatcherAssert.assertThat((Object)hNull.xor(hDeadBeef), (Matcher)CoreMatchers.equalTo((Object)hDeadBeef));
        MatcherAssert.assertThat((Object)hDeadBeef.xor(hNull), (Matcher)CoreMatchers.equalTo((Object)hDeadBeef));
        MatcherAssert.assertThat((Object)hDeadBeef.xor(hDeadBeef), (Matcher)CoreMatchers.equalTo((Object)hNull));
        U64 h1 = U64.of((long)1L);
        U64 h8 = U64.of((long)Long.MIN_VALUE);
        U64 h81 = U64.of((long)-9223372036854775807L);
        MatcherAssert.assertThat((Object)h1.xor(h8), (Matcher)CoreMatchers.equalTo((Object)h81));
    }

    @Test
    public void testKeyBits() {
        U64 zeroU = U64.of((long)0L);
        MatcherAssert.assertThat((Object)zeroU.prefixBits(0), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)zeroU.prefixBits(16), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)zeroU.prefixBits(32), (Matcher)CoreMatchers.equalTo((Object)0));
        this.checkInvalidKeyBitSize(zeroU, 33);
        this.checkInvalidKeyBitSize(zeroU, 64);
        MatcherAssert.assertThat((Object)zeroU.prefixBits(3), (Matcher)CoreMatchers.equalTo((Object)0));
        U64 positiveU = U64.of((long)1311768465173141112L);
        MatcherAssert.assertThat((Object)positiveU.prefixBits(0), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)positiveU.prefixBits(16), (Matcher)CoreMatchers.equalTo((Object)4660));
        MatcherAssert.assertThat((Object)positiveU.prefixBits(32), (Matcher)CoreMatchers.equalTo((Object)305419896));
        this.checkInvalidKeyBitSize(positiveU, 33);
        this.checkInvalidKeyBitSize(positiveU, 64);
        U64 signedBitU = U64.of((long)-8690466094656961759L);
        MatcherAssert.assertThat((Object)signedBitU.prefixBits(0), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)signedBitU.prefixBits(16), (Matcher)CoreMatchers.equalTo((Object)34661));
        MatcherAssert.assertThat((Object)signedBitU.prefixBits(32), (Matcher)CoreMatchers.equalTo((Object)-2023406815));
        this.checkInvalidKeyBitSize(signedBitU, 33);
        this.checkInvalidKeyBitSize(signedBitU, 64);
    }

    @Before
    public void setup() {
        U64 u0 = U64.of((long)0L);
        U64 u1 = U64.of((long)1L);
        U64 u2 = U64.of((long)2L);
        U64 u7f = U64.of((long)Long.MAX_VALUE);
        U64 u8 = U64.of((long)Long.MIN_VALUE);
        U64 uf = U64.of((long)-1L);
        this.triples = new Triple[]{Triple.of(u0, u0, u0), Triple.of(u0, u1, u1), Triple.of(u1, u1, u2), Triple.of(u1, uf, u0), Triple.of(uf, uf, U64.of((long)-2L)), Triple.of(u0, uf, uf), Triple.of(u7f, u1, u8), Triple.of(U64.of((long)1311768467463790321L), U64.of((long)-1311768467463790321L), U64.ZERO)};
    }

    @Test
    public void testAddSubtract() {
        for (Triple t : this.triples) {
            MatcherAssert.assertThat((String)t.msg("{0} + {1} = {2}"), (Object)t.a.add(t.b), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{1} + {0} = {2}"), (Object)t.b.add(t.a), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{2} - {0} = {1}"), (Object)t.c.subtract(t.a), (Matcher)CoreMatchers.equalTo((Object)t.b));
            MatcherAssert.assertThat((String)t.msg("{2} - {1} = {0}"), (Object)t.c.subtract(t.b), (Matcher)CoreMatchers.equalTo((Object)t.a));
        }
    }

    @Test
    public void testAddSubtractBuilder() {
        for (Triple t : this.triples) {
            MatcherAssert.assertThat((String)t.msg("{0} + {1} = {2}"), (Object)t.a.builder().add((Object)t.b).build(), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{1} + {0} = {2}"), (Object)t.b.builder().add((Object)t.a).build(), (Matcher)CoreMatchers.equalTo((Object)t.c));
            MatcherAssert.assertThat((String)t.msg("{2} - {0} = {1}"), (Object)t.c.builder().subtract((Object)t.a).build(), (Matcher)CoreMatchers.equalTo((Object)t.b));
            MatcherAssert.assertThat((String)t.msg("{2} - {1} = {0}"), (Object)t.c.builder().subtract((Object)t.b).build(), (Matcher)CoreMatchers.equalTo((Object)t.a));
        }
    }

    private void checkInvalidKeyBitSize(U64 u, int prefixBit) {
        try {
            u.prefixBits(prefixBit);
            Assert.fail((String)("Expected exception not thrown for " + prefixBit + " bits"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBitwiseOperators() {
        U64 notPi = U64.of((long)3549216002486605715L);
        U64 notE = U64.of((long)2817045652685014307L);
        MatcherAssert.assertThat((Object)notPi.inverse(), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)-3549216002486605716L)));
        MatcherAssert.assertThat((Object)notPi.and(notE), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)2377909399350412547L)));
        MatcherAssert.assertThat((Object)notPi.or(notE), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)3988352255821207475L)));
        MatcherAssert.assertThat((Object)notPi.xor(notE), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)1610442856470794928L)));
    }

    @Test
    public void testBitwiseOperatorsBuilder() {
        U64 notPi = U64.of((long)3549216002486605715L);
        U64 notE = U64.of((long)2817045652685014307L);
        MatcherAssert.assertThat((Object)notPi.builder().invert().build(), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)-3549216002486605716L)));
        MatcherAssert.assertThat((Object)notPi.builder().and((Object)notE).build(), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)2377909399350412547L)));
        MatcherAssert.assertThat((Object)notPi.builder().or((Object)notE).build(), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)3988352255821207475L)));
        MatcherAssert.assertThat((Object)notPi.builder().xor((Object)notE).build(), (Matcher)CoreMatchers.equalTo((Object)U64.of((long)1610442856470794928L)));
    }

    public static class Triple {
        U64 a;
        U64 b;
        U64 c;

        public Triple(U64 a, U64 b, U64 c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public static Triple of(U64 a, U64 b, U64 c) {
            return new Triple(a, b, c);
        }

        public String msg(String string) {
            return MessageFormat.format(string, this.a, this.b, this.c);
        }
    }
}

