/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupCapabilities;
import org.projectfloodlight.openflow.protocol.OFGroupFeaturesStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupFeaturesStatsReplyVer15;

public class OFGroupFeaturesStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] GROUP_FEATURES_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 56, 18, 52, 86, 120, 0, 8, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupFeaturesStatsReply.Builder builder = this.factory.buildGroupFeaturesStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setTypes(0L).setCapabilities((Set)ImmutableSet.of((Object)OFGroupCapabilities.CHAINING)).setMaxGroupsAll(5L).setMaxGroupsSelect(0L).setMaxGroupsIndirect(0L).setMaxGroupsFf(0L).setActionsAll(8L).setActionsSelect(0L).setActionsIndirect(0L).setActionsFf(0L).build();
        OFGroupFeaturesStatsReply groupFeaturesStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupFeaturesStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_FEATURES_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupFeaturesStatsReply.Builder builder = this.factory.buildGroupFeaturesStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setTypes(0L).setCapabilities((Set)ImmutableSet.of((Object)OFGroupCapabilities.CHAINING)).setMaxGroupsAll(5L).setMaxGroupsSelect(0L).setMaxGroupsIndirect(0L).setMaxGroupsFf(0L).setActionsAll(8L).setActionsSelect(0L).setActionsIndirect(0L).setActionsFf(0L).build();
        OFGroupFeaturesStatsReply groupFeaturesStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_FEATURES_STATS_REPLY_SERIALIZED);
        OFGroupFeaturesStatsReply groupFeaturesStatsReplyRead = OFGroupFeaturesStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_FEATURES_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupFeaturesStatsReplyBuilt, (Object)groupFeaturesStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_FEATURES_STATS_REPLY_SERIALIZED);
        OFGroupFeaturesStatsReply groupFeaturesStatsReply = OFGroupFeaturesStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_FEATURES_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupFeaturesStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_FEATURES_STATS_REPLY_SERIALIZED));
    }
}

