/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableEntryDescStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U128;

public class OFBsnGentableEntryDescStatsReplyVer13Test {
    OFFactory factory;
    static final byte[] BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED = new byte[]{4, 19, 0, 100, 18, 52, 86, 120, -1, -1, 0, 0, 0, 0, 0, 0, 0, 92, 22, -57, 0, 0, 0, 2, 0, 38, 0, 8, -2, -36, -70, -104, 118, 84, 50, 16, -1, -18, -52, -69, -86, -103, -120, 0, 0, 0, 0, 8, 0, 0, 0, 5, 0, 1, 0, 10, -1, -18, -35, -52, -69, 0, 0, 38, 0, 8, -2, -36, -70, -104, 118, 84, 50, 16, -1, -18, -52, -69, -86, -103, -120, 1, 0, 0, 0, 8, 0, 0, 0, 6, 0, 1, 0, 10, -1, -18, -35, -52, -69, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnGentableEntryDescStatsReply.Builder builder = this.factory.buildBsnGentableEntryDescStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.buildBsnGentableEntryDescStatsEntry().setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187652608L)).setKey((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)5)))).setValue((List)ImmutableList.of((Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"ff:ee:dd:cc:bb:00")))).build(), (Object)this.factory.buildBsnGentableEntryDescStatsEntry().setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187652607L)).setKey((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)6)))).setValue((List)ImmutableList.of((Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"ff:ee:dd:cc:bb:01")))).build()));
        OFBsnGentableEntryDescStatsReply bsnGentableEntryDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bsnGentableEntryDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnGentableEntryDescStatsReply.Builder builder = this.factory.buildBsnGentableEntryDescStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.buildBsnGentableEntryDescStatsEntry().setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187652608L)).setKey((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)5)))).setValue((List)ImmutableList.of((Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"ff:ee:dd:cc:bb:00")))).build(), (Object)this.factory.buildBsnGentableEntryDescStatsEntry().setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187652607L)).setKey((List)ImmutableList.of((Object)this.factory.bsnTlvs().port(OFPort.of((int)6)))).setValue((List)ImmutableList.of((Object)this.factory.bsnTlvs().mac(MacAddress.of((String)"ff:ee:dd:cc:bb:01")))).build()));
        OFBsnGentableEntryDescStatsReply bsnGentableEntryDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED);
        OFBsnGentableEntryDescStatsReply bsnGentableEntryDescStatsReplyRead = OFBsnGentableEntryDescStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnGentableEntryDescStatsReplyBuilt, (Object)bsnGentableEntryDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED);
        OFBsnGentableEntryDescStatsReply bsnGentableEntryDescStatsReply = OFBsnGentableEntryDescStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bsnGentableEntryDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_ENTRY_DESC_STATS_REPLY_SERIALIZED));
    }
}

