/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionApplyActions;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructions;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionApplyActionsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFInstructionsVer15;

public class OFInstructionApplyActionsVer15Test {
    OFInstructions factory;
    static final byte[] INSTRUCTION_APPLY_ACTIONS_SERIALIZED = new byte[]{0, 4, 0, 16, 0, 0, 0, 0, 0, 12, 0, 8, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFInstructionsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFInstructionApplyActions.Builder builder = this.factory.buildApplyActions();
        OFActions actions = OFFactories.getFactory((OFVersion)OFVersion.OF_15).actions();
        builder.setActions((List)ImmutableList.of((Object)actions.copyTtlIn()));
        OFInstructionApplyActions instructionApplyActions = builder.build();
        ByteBuf bb = Unpooled.buffer();
        instructionApplyActions.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_APPLY_ACTIONS_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFInstructionApplyActions.Builder builder = this.factory.buildApplyActions();
        OFActions actions = OFFactories.getFactory((OFVersion)OFVersion.OF_15).actions();
        builder.setActions((List)ImmutableList.of((Object)actions.copyTtlIn()));
        OFInstructionApplyActions instructionApplyActionsBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_APPLY_ACTIONS_SERIALIZED);
        OFInstructionApplyActions instructionApplyActionsRead = OFInstructionApplyActionsVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_APPLY_ACTIONS_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)instructionApplyActionsBuilt, (Object)instructionApplyActionsRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_APPLY_ACTIONS_SERIALIZED);
        OFInstructionApplyActions instructionApplyActions = OFInstructionApplyActionsVer15.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_APPLY_ACTIONS_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        instructionApplyActions.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_APPLY_ACTIONS_SERIALIZED));
    }
}

