// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFOxsIdleTimeVer15 implements OFOxsIdleTime {
    private static final Logger logger = LoggerFactory.getLogger(OFOxsIdleTimeVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 12;

        private final static U64 DEFAULT_VALUE = U64.ZERO;

    // OF message fields
    private final U64 value;
//
    // Immutable default instance
    final static OFOxsIdleTimeVer15 DEFAULT = new OFOxsIdleTimeVer15(
        DEFAULT_VALUE
    );

    // package private constructor - used by readers, builders, and factory
    OFOxsIdleTimeVer15(U64 value) {
        if(value == null) {
            throw new NullPointerException("OFOxsIdleTimeVer15: property value cannot be null");
        }
        this.value = value;
    }

    // Accessors for OF message fields
    @Override
    public long getTypeLen() {
        return 0x80020208L;
    }

    @Override
    public U64 getValue() {
        return value;
    }

    @Override
    public StatField<U64> getStatField() {
        return StatField.IDLE_TIME;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    public OFOxs<U64> getCanonical() {
        // exact match OXM is always canonical
        return this;
    }

    @Override
    public U64 getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFOxsIdleTime.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFOxsIdleTime.Builder {
        final OFOxsIdleTimeVer15 parentMessage;

        // OF message fields
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFOxsIdleTimeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getTypeLen() {
        return 0x80020208L;
    }

    @Override
    public U64 getValue() {
        return value;
    }

    @Override
    public OFOxsIdleTime.Builder setValue(U64 value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public StatField<U64> getStatField() {
        return StatField.IDLE_TIME;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxs<U64> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
    }

    @Override
    public U64 getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFOxsIdleTime build() {
                U64 value = this.valueSet ? this.value : parentMessage.value;
                if(value == null)
                    throw new NullPointerException("Property value must not be null");

                //
                return new OFOxsIdleTimeVer15(
                    value
                );
        }

    }

    static class Builder implements OFOxsIdleTime.Builder {
        // OF message fields
        private boolean valueSet;
        private U64 value;

    @Override
    public long getTypeLen() {
        return 0x80020208L;
    }

    @Override
    public U64 getValue() {
        return value;
    }

    @Override
    public OFOxsIdleTime.Builder setValue(U64 value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public StatField<U64> getStatField() {
        return StatField.IDLE_TIME;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxs<U64> getCanonical()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
    }

    @Override
    public U64 getMask()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFOxsIdleTime build() {
            U64 value = this.valueSet ? this.value : DEFAULT_VALUE;
            if(value == null)
                throw new NullPointerException("Property value must not be null");


            return new OFOxsIdleTimeVer15(
                    value
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFOxsIdleTime> {
        @Override
        public OFOxsIdleTime readFrom(ByteBuf bb) throws OFParseError {
            // fixed value property typeLen == 0x80020208L
            int typeLen = bb.readInt();
            if(typeLen != (int) 0x80020208)
                throw new OFParseError("Wrong typeLen: Expected=0x80020208L(0x80020208L), got="+typeLen);
            U64 value = U64.ofRaw(bb.readLong());

            OFOxsIdleTimeVer15 oxsIdleTimeVer15 = new OFOxsIdleTimeVer15(
                    value
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", oxsIdleTimeVer15);
            return oxsIdleTimeVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFOxsIdleTimeVer15Funnel FUNNEL = new OFOxsIdleTimeVer15Funnel();
    static class OFOxsIdleTimeVer15Funnel implements Funnel<OFOxsIdleTimeVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFOxsIdleTimeVer15 message, PrimitiveSink sink) {
            // fixed value property typeLen = 0x80020208L
            sink.putInt((int) 0x80020208);
            message.value.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFOxsIdleTimeVer15> {
        @Override
        public void write(ByteBuf bb, OFOxsIdleTimeVer15 message) {
            // fixed value property typeLen = 0x80020208L
            bb.writeInt((int) 0x80020208);
            bb.writeLong(message.value.getValue());


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFOxsIdleTimeVer15(");
        b.append("value=").append(value);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFOxsIdleTimeVer15 other = (OFOxsIdleTimeVer15) obj;

        if (value == null) {
            if (other.value != null)
                return false;
        } else if (!value.equals(other.value))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((value == null) ? 0 : value.hashCode());
        return result;
    }

}
