/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChannelUtils.class);

    public static String readFixedLengthString(ByteBuf bb, int length) {
        byte[] dst = new byte[length];
        bb.readBytes(dst, 0, length);
        int validLength = 0;
        for (validLength = 0; validLength < length && dst[validLength] != 0; ++validLength) {
        }
        return new String(dst, 0, validLength, Charsets.US_ASCII);
    }

    public static void writeFixedLengthString(ByteBuf bb, String string, int length) {
        int l = string.length();
        if (l > length) {
            throw new IllegalArgumentException("Error writing string: length=" + l + " > max Length=" + length);
        }
        bb.writeBytes(string.getBytes(Charsets.US_ASCII));
        if (l < length) {
            bb.writeZero(length - l);
        }
    }

    public static byte[] readBytes(ByteBuf bb, int length) {
        byte[] byteArray = new byte[length];
        bb.readBytes(byteArray);
        return byteArray;
    }

    public static void writeBytes(ByteBuf bb, byte[] byteArray) {
        bb.writeBytes(byteArray);
    }

    public static <T> List<T> readList(ByteBuf bb, int length, OFMessageReader<T> reader) throws OFParseError {
        int end = bb.readerIndex() + length;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (logger.isTraceEnabled()) {
            logger.trace("readList(length={}, reader={})", (Object)length, reader.getClass());
        }
        while (bb.readerIndex() < end) {
            T read = reader.readFrom(bb);
            if (logger.isTraceEnabled()) {
                logger.trace("readList: read={}, left={}", read, (Object)(end - bb.readerIndex()));
            }
            builder.add(read);
        }
        if (bb.readerIndex() != end) {
            throw new IllegalStateException("Overread length: length=" + length + " overread by " + (bb.readerIndex() - end) + " reader: " + reader);
        }
        return builder.build();
    }

    public static void writeList(ByteBuf bb, List<? extends Writeable> writeables) {
        for (Writeable writeable : writeables) {
            writeable.writeTo(bb);
        }
    }
}

