/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.VlanVid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFVlanVidMatch
implements OFValueType<OFVlanVidMatch> {
    private static final Logger logger = LoggerFactory.getLogger(OFVlanVidMatch.class);
    private static final short VALIDATION_MASK = 8191;
    private static final short PRESENT_VAL = 4096;
    private static final short VLAN_MASK = 4095;
    private static final short NONE_VAL = 0;
    private static final short UNTAGGED_VAL_OF13 = 0;
    private static final short UNTAGGED_VAL_OF10 = -1;
    static final int LENGTH = 2;
    public static final OFVlanVidMatch PRESENT = new OFVlanVidMatch(4096);
    public static final OFVlanVidMatch NONE = new OFVlanVidMatch(0);
    public static final OFVlanVidMatch NO_MASK = new OFVlanVidMatch(-1);
    public static final OFVlanVidMatch FULL_MASK = NONE;
    public static final OFVlanVidMatch UNTAGGED = new OFVlanVidMatch(0){

        @Override
        public void write2BytesOF10(ByteBuf c) {
            c.writeShort(-1);
        }
    };
    private final short vid;
    private volatile byte[] bytesCache = null;

    private OFVlanVidMatch(short vid) {
        this.vid = vid;
    }

    public static OFVlanVidMatch ofRawVid(short vid) {
        if (vid == 0) {
            return UNTAGGED;
        }
        if (vid == 4096) {
            return PRESENT;
        }
        if (vid == -1) {
            logger.warn("Warning: received OF1.0 untagged vlan value (0xFFFF) in OF1.3 VlanVid. Treating as UNTAGGED");
            return UNTAGGED;
        }
        if ((vid & 0x1FFF) != vid) {
            throw new IllegalArgumentException(String.format("Illegal VLAN value: %x", vid));
        }
        return new OFVlanVidMatch(vid);
    }

    public static OFVlanVidMatch ofVlanVid(VlanVid vid) {
        if (vid == null) {
            return UNTAGGED;
        }
        if (VlanVid.NO_MASK.equals(vid)) {
            return NO_MASK;
        }
        return OFVlanVidMatch.ofVlan(vid.getVlan());
    }

    public static OFVlanVidMatch ofVlan(int vlan) {
        if ((vlan & 0xFFF) != vlan) {
            throw new IllegalArgumentException(String.format("Illegal VLAN value: %x", vlan));
        }
        return OFVlanVidMatch.ofRawVid((short)(vlan | 0x1000));
    }

    public static OFVlanVidMatch ofVlanOF10(short of10vlan) {
        if (of10vlan == 0) {
            return NONE;
        }
        if (of10vlan == -1) {
            return UNTAGGED;
        }
        return OFVlanVidMatch.ofVlan(of10vlan);
    }

    public boolean isPresentBitSet() {
        return (this.vid & 0x1000) != 0;
    }

    public short getVlan() {
        return (short)(this.vid & 0xFFF);
    }

    @Nullable
    public VlanVid getVlanVid() {
        if (this.equals(NO_MASK)) {
            return VlanVid.NO_MASK;
        }
        if (this.isPresentBitSet()) {
            return VlanVid.ofVlan((short)(this.vid & 0xFFF));
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OFVlanVidMatch)) {
            return false;
        }
        OFVlanVidMatch other = (OFVlanVidMatch)obj;
        return other.vid == this.vid;
    }

    public int hashCode() {
        int prime = 13873;
        return this.vid * prime;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.vid);
    }

    public short getRawVid() {
        return this.vid;
    }

    @Override
    public int getLength() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        if (this.bytesCache == null) {
            OFVlanVidMatch oFVlanVidMatch = this;
            synchronized (oFVlanVidMatch) {
                if (this.bytesCache == null) {
                    this.bytesCache = new byte[]{(byte)(this.vid >>> 8 & 0xFF), (byte)(this.vid >>> 0 & 0xFF)};
                }
            }
        }
        return Arrays.copyOf(this.bytesCache, this.bytesCache.length);
    }

    public void write2Bytes(ByteBuf c) {
        c.writeShort((int)this.vid);
    }

    public void write2BytesOF10(ByteBuf c) {
        c.writeShort((int)this.getVlan());
    }

    public static OFVlanVidMatch read2Bytes(ByteBuf c) throws OFParseError {
        return OFVlanVidMatch.ofRawVid(c.readShort());
    }

    public static OFVlanVidMatch read2BytesOF10(ByteBuf c) throws OFParseError {
        return OFVlanVidMatch.ofVlanOF10(c.readShort());
    }

    @Override
    public OFVlanVidMatch applyMask(OFVlanVidMatch mask) {
        return OFVlanVidMatch.ofRawVid((short)(this.vid & mask.vid));
    }

    @Override
    public int compareTo(OFVlanVidMatch o) {
        return Shorts.compare((short)this.vid, (short)o.vid);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.vid);
    }
}

